/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.BlockStmt;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.crosscuts.ast.AspectDec;
import org.aspectj.compiler.crosscuts.ast.PerClause;
import org.aspectj.compiler.crosscuts.ast.PlanData;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlan;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlanner;
import org.aspectj.util.FuzzyBoolean;

public class PerSingleton
extends PerClause {
    FieldDec aspectField;

    public String toShortString() {
        return "issingleton";
    }

    public JpPlanner makeInnerPlanner(PlanData planData) {
        return new JpPlanner(){

            public FuzzyBoolean fastMatch(JoinPoint jp) {
                return FuzzyBoolean.MAYBE;
            }

            public JpPlan makePlan(JoinPoint jp) {
                JpPlan plan = new JpPlan(jp);
                plan.test = PerSingleton.this.maybeMakeTest(jp);
                plan.setInstanceExpr(PerSingleton.this.makeAspectInstance());
                return plan;
            }
        };
    }

    public JpPlanner makeInitializerPlanner(PlanData planData) {
        return JpPlanner.NO_PLANNER;
    }

    String makeAspectFieldName() {
        return this.getAST().makeGeneratedName("aspectInstance");
    }

    FieldDec makeAspectField() {
        AST ast = this.getAST();
        FieldDec ret = ast.makeField(ast.makeModifiers(25), this.getAspectType(), this.makeAspectFieldName(), ast.makeNew(this.getAspectType()));
        return ret;
    }

    Expr maybeMakeTest(JoinPoint point) {
        AST ast = this.getAST();
        if (this.getAspectType().isSubtypeOf(point.getBytecodeType())) {
            return ast.makeCall(this.hasAspectMethod, (Expr)ast.makeTypeExpr(this.getAspectType()));
        }
        return null;
    }

    protected MethodDec makeAspectOfMethod() {
        AST ast = this.getAST();
        BlockStmt body = ast.makeBlock(ast.makeReturn(this.makeAspectInstance()));
        return this.makeAspectOfMethod(ast.makeFormals(), body);
    }

    protected MethodDec makeHasAspectMethod() {
        AST ast = this.getAST();
        BlockStmt body = ast.makeBlock(ast.makeReturn(ast.makeBinop("!=", this.makeAspectInstance(), ast.makeNull())));
        return this.makeHasAspectMethod(ast.makeFormals(), body);
    }

    Expr makeAspectInstance() {
        return this.getAST().makeGet(this.aspectField);
    }

    public Expr makeAspectOfExpr(Expr fromObject) {
        return this.getAST().makeCall(this.aspectOfMethod, (Expr)this.getAST().makeTypeExpr(this.getAspectType()));
    }

    public void setupAspect() {
        AspectDec typeDec = this.getAspectDec();
        this.aspectField = this.makeAspectField();
        typeDec.addToBody(this.aspectField);
        super.setupAspect();
    }

    public PerSingleton(SourceLocation location) {
        super(location);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        PerSingleton ret = new PerSingleton(this.getSourceLocation());
        ret.preCopy(walker, this);
        return ret;
    }

    public String getDefaultDisplayName() {
        return "PerSingleton()";
    }
}

