/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.BlockStmt;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Stmts;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.VarDec;
import org.aspectj.compiler.crosscuts.ast.CFlowPlanner;
import org.aspectj.compiler.crosscuts.ast.Pcd;
import org.aspectj.compiler.crosscuts.ast.PerClause;
import org.aspectj.compiler.crosscuts.ast.PlanData;
import org.aspectj.compiler.crosscuts.joinpoints.CFlowEntryPlan;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlan;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlanner;
import org.aspectj.compiler.crosscuts.joinpoints.WrappedJpPlanner;
import org.aspectj.util.FuzzyBoolean;

public class PerCFlow
extends PerClause
implements CFlowPlanner {
    private FieldDec stack;
    private static int ecounter = 0;
    protected Pcd pcd;
    protected boolean includesRoot;

    public String toShortString() {
        return "percflow" + (this.includesRoot ? "below" : "") + "(" + this.getPcd().toShortString() + ")";
    }

    public JpPlanner makeInnerPlanner(PlanData planData) {
        return new JpPlanner(){

            public FuzzyBoolean fastMatch(JoinPoint jp) {
                return FuzzyBoolean.MAYBE;
            }

            public JpPlan makePlan(JoinPoint jp) {
                JpPlan plan = new JpPlan(jp);
                plan.test = PerCFlow.this.testStackExpr();
                plan.setInstanceExpr(PerCFlow.this.makeAspectInstance());
                plan.addDependency(this);
                return plan;
            }
        };
    }

    public JpPlanner makeInitializerPlanner(PlanData planData) {
        return new WrappedJpPlanner(this.getPcd().makePlanner(planData)){

            public JpPlan makePlan(JoinPoint jp) {
                JpPlan plan = super.makePlan(jp);
                return new CFlowEntryPlan(plan, PerCFlow.this);
            }
        };
    }

    FieldDec getStackField() {
        if (this.stack != null) {
            return this.stack;
        }
        AST ast = this.getAST();
        String name = "eachcflow$ajc";
        Type type = this.getTypeManager().getType("org.aspectj.runtime.internal", "CFlowStack");
        Modifiers modifiers = ast.makeModifiers(25);
        this.stack = ast.makeField(modifiers, type, name, ast.makeNew(type));
        this.getAspectDec().getBody().add(0, this.stack);
        return this.stack;
    }

    Expr getStackVar() {
        return this.getAST().makeGet(this.getStackField());
    }

    Expr testStackExpr() {
        return this.getAST().makeCall(this.getStackVar(), "isValid");
    }

    Expr pushStackExpr() {
        return this.pushStackExpr(this.getAST().makeNew(this.getTypeManager().getObjectType()));
    }

    Expr pushStackExpr(Expr expr) {
        return this.getAST().makeCall(this.getStackVar(), "push", expr);
    }

    Expr popStackExpr() {
        return this.getAST().makeCall(this.getStackVar(), "pop");
    }

    Expr peekStackExpr() {
        return this.getAST().makeCall(this.getStackVar(), "peek");
    }

    public Stmts wrapPushPop(JpPlan plan, Stmts body) {
        AST ast = this.getAST();
        Expr test = plan.getDynamicTest();
        if (test == null) {
            return ast.makeStmts(ast.makeStmt(this.pushStackExpr(this.makeNewAspectExpr())), ast.makeTryFinally(ast.makeBlock(body), ast.makeBlock(this.popStackExpr())));
        }
        VarDec tmp = ast.makeFinalVar(this.getTypeManager().booleanType, "ajc_enter_ecflow_" + ecounter++, test);
        return ast.makeStmts(tmp, ast.makeIf(ast.makeVar(tmp), ast.makeStmt(this.pushStackExpr(this.makeNewAspectExpr()))), ast.makeTryFinally(ast.makeBlock(body), ast.makeBlock(ast.makeIf(ast.makeVar(tmp), ast.makeStmt(this.popStackExpr())))));
    }

    Expr makeAspectInstance() {
        return this.getAST().makeCast(this.getAspectType(), this.peekStackExpr());
    }

    public Expr makeAspectOfExpr(Expr fromObject) {
        return this.makeAspectInstance();
    }

    Expr makeNewAspectExpr() {
        return this.getAST().makeNew(this.getAspectType());
    }

    protected MethodDec makeHasAspectMethod() {
        AST ast = this.getAST();
        BlockStmt body = ast.makeBlock(ast.makeReturn(this.testStackExpr()));
        return this.makeHasAspectMethod(ast.makeFormals(), body);
    }

    protected MethodDec makeAspectOfMethod() {
        AST ast = this.getAST();
        VarDec aspectDec = ast.makeVarDec(this.getAspectType(), "asp", this.makeAspectInstance());
        BlockStmt body = ast.makeBlock(aspectDec, ast.makeIf(ast.makeNonNullTest(ast.makeVar(aspectDec)), ast.makeReturn(ast.makeVar(aspectDec))), ast.makeThrow(this.getTypeManager().getType("org.aspectj.lang", "NoAspectBoundException")));
        return this.makeAspectOfMethod(ast.makeFormals(), body);
    }

    public Pcd getPcd() {
        return this.pcd;
    }

    public void setPcd(Pcd _pcd) {
        if (_pcd != null) {
            _pcd.setParent(this);
        }
        this.pcd = _pcd;
    }

    public boolean getIncludesRoot() {
        return this.includesRoot;
    }

    public void setIncludesRoot(boolean _includesRoot) {
        this.includesRoot = _includesRoot;
    }

    public PerCFlow(SourceLocation location, Pcd _pcd, boolean _includesRoot) {
        super(location);
        this.setPcd(_pcd);
        this.setIncludesRoot(_includesRoot);
    }

    protected PerCFlow(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        PerCFlow ret = new PerCFlow(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.pcd != null) {
            ret.setPcd((Pcd)walker.process(this.pcd));
        }
        ret.includesRoot = this.includesRoot;
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.pcd;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "pcd";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setPcd((Pcd)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 1;
    }

    public String getDefaultDisplayName() {
        return "PerCFlow(includesRoot: " + this.includesRoot + ")";
    }
}

