/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import java.util.Set;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeD;
import org.aspectj.compiler.crosscuts.ast.NamePattern;

public class NameTypeDPattern
extends ASTObject {
    private Set _typeDecs = null;
    protected String packageName;
    protected NamePattern className;
    protected boolean includeSubpackages;

    private String getMyPackageName() {
        if (this.packageName == null) {
            return this.getCompilationUnit().getPackageName();
        }
        return this.packageName;
    }

    public boolean matches(TypeD typeD) {
        return this.matches(typeD.getType());
    }

    private boolean matches(Type type) {
        if (type == null) {
            return false;
        }
        if (!this.className.matches(type.getId())) {
            return false;
        }
        String packageName = type.getPackageName();
        String myPackageName = this.getMyPackageName();
        if (myPackageName == null) {
            return packageName == null;
        }
        if (packageName == null) {
            return false;
        }
        if (this.includeSubpackages) {
            return packageName.startsWith(myPackageName);
        }
        return myPackageName.equals(packageName);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String _packageName) {
        this.packageName = _packageName;
    }

    public NamePattern getClassName() {
        return this.className;
    }

    public void setClassName(NamePattern _className) {
        this.className = _className;
    }

    public boolean getIncludeSubpackages() {
        return this.includeSubpackages;
    }

    public void setIncludeSubpackages(boolean _includeSubpackages) {
        this.includeSubpackages = _includeSubpackages;
    }

    public NameTypeDPattern(SourceLocation location, String _packageName, NamePattern _className, boolean _includeSubpackages) {
        super(location);
        this.setPackageName(_packageName);
        this.setClassName(_className);
        this.setIncludeSubpackages(_includeSubpackages);
    }

    protected NameTypeDPattern(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        NameTypeDPattern ret = new NameTypeDPattern(this.getSourceLocation());
        ret.preCopy(walker, this);
        ret.packageName = this.packageName;
        ret.className = this.className;
        ret.includeSubpackages = this.includeSubpackages;
        return ret;
    }

    public String getDefaultDisplayName() {
        return "NameTypeDPattern(packageName: " + this.packageName + ", " + "className: " + this.className + ", " + "includeSubpackages: " + this.includeSubpackages + ")";
    }
}

