/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import org.aspectj.compiler.base.InnerInfoPass;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.ScopeWalker;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.ThisExpr;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.ast.VarDec;
import org.aspectj.compiler.base.ast.VarExpr;
import org.aspectj.compiler.base.ast.Walker;
import org.aspectj.compiler.crosscuts.ast.AdviceDec;
import org.aspectj.compiler.crosscuts.ast.AfterReturningAdviceDec;
import org.aspectj.compiler.crosscuts.ast.AfterThrowingAdviceDec;
import org.aspectj.compiler.crosscuts.ast.Pcd;
import org.aspectj.compiler.crosscuts.ast.PlanData;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlan;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlanner;
import org.aspectj.util.FuzzyBoolean;

public class IfPcd
extends Pcd {
    private boolean containsInners = false;
    protected Expr test;

    public String toShortString() {
        return "if(" + this.test.unparse() + ")";
    }

    public void walkInnerInfo(InnerInfoPass w) {
        int context = w.inMember(true);
        super.walkInnerInfo(w);
        w.restoreContext(context);
    }

    public void checkStatic() {
        this.showNonStaticError();
    }

    public void checkSpec() {
        this.getTest().assertType(this.getTypeManager().booleanType);
        new Walker(this.getCompiler()){

            public void postProcess(ASTObject object) {
                if (object instanceof VarExpr) {
                    IfPcd.this.checkVarExpr((VarExpr)object);
                }
            }
        }.process(this.getTest());
    }

    private AdviceDec getEnclosingAdviceDec(Pcd pcd) {
        ASTObject parent = pcd.getParent();
        if (parent == null) {
            return null;
        }
        if (parent instanceof AdviceDec) {
            return (AdviceDec)parent;
        }
        if (parent instanceof Pcd) {
            return this.getEnclosingAdviceDec((Pcd)parent);
        }
        return null;
    }

    private void checkVarExpr(VarExpr var) {
        AdviceDec adviceDec;
        if (var.isLhs()) {
            var.showError("can not assign to join point bound variables");
        }
        if ((adviceDec = this.getEnclosingAdviceDec(this)) == null) {
            return;
        }
        VarDec dec = var.getVarDec();
        if (adviceDec instanceof AfterReturningAdviceDec) {
            if (((AfterReturningAdviceDec)adviceDec).getExtraFormal() == dec) {
                var.showError("can not use after returning formal in 'if' pcd");
            }
            return;
        }
        if (adviceDec instanceof AfterThrowingAdviceDec) {
            if (((AfterThrowingAdviceDec)adviceDec).getExtraFormal() == dec) {
                var.showError("can not use after throwing formal in 'if' pcd");
            }
            return;
        }
    }

    public void walkScope(ScopeWalker walker) {
        if (!walker.walkBodies()) {
            return;
        }
        walker.pushBlockScope();
        AST ast = this.getAST();
        walker.addVarDec(ast.makeFinalFormal(this.getTypeManager().getJoinPointType(), "thisJoinPoint"));
        walker.addVarDec(ast.makeFinalFormal(this.getTypeManager().getJoinPointStaticPartType(), "thisJoinPointStaticPart"));
        super.walkScope(walker);
        walker.popScope();
    }

    public JpPlanner makePlanner(final PlanData planData) {
        return new JpPlanner(){

            protected FuzzyBoolean fastMatch(JoinPoint jp) {
                return FuzzyBoolean.MAYBE;
            }

            public JpPlan makePlan(JoinPoint jp) {
                Expr planTest = IfPcd.this.makeTestExpr(jp, planData);
                if (IfPcd.this.containsInners) {
                    IfPcd.this.showError("can't use anonymous types in if expressions (compiler limitation)");
                }
                if (planTest == null) {
                    return JpPlan.NO_PLAN;
                }
                JpPlan plan = new JpPlan(jp);
                plan.ifTest = planTest;
                return plan;
            }
        };
    }

    Expr makeTestExpr(JoinPoint jp, PlanData planData) {
        final VarDec aspectInstanceDec = this.getAST().makeVarDec(planData.getAspectDec().getType(), "aspect$instance", null);
        CopyWalker copyWalker = new CopyWalker(this.getCompiler()){

            public ASTObject process(ASTObject node) {
                if ((node = super.process(node)) instanceof ThisExpr) {
                    return IfPcd.this.getAST().makeVar(aspectInstanceDec);
                }
                if (node instanceof TypeDec) {
                    IfPcd.this.containsInners = true;
                }
                return node;
            }
        };
        return (Expr)copyWalker.process(this.test);
    }

    public Expr getTest() {
        return this.test;
    }

    public void setTest(Expr _test) {
        if (_test != null) {
            _test.setParent(this);
        }
        this.test = _test;
    }

    public IfPcd(SourceLocation location, Expr _test) {
        super(location);
        this.setTest(_test);
    }

    protected IfPcd(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        IfPcd ret = new IfPcd(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.test != null) {
            ret.setTest((Expr)walker.process(this.test));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.test;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "test";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setTest((Expr)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 1;
    }

    public String getDefaultDisplayName() {
        return "IfPcd()";
    }
}

