/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Field;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.SemanticObject;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.crosscuts.ast.DecPattern;
import org.aspectj.compiler.crosscuts.ast.GenTypeName;
import org.aspectj.compiler.crosscuts.ast.NamePattern;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;
import org.aspectj.util.FuzzyBoolean;

public class FieldPattern
extends DecPattern {
    protected GenTypeName fieldTypeName;
    protected NamePattern id;

    public String toShortString() {
        String mods = this.modifiers.toShortString();
        if (mods.length() > 0) {
            mods = mods + " ";
        }
        mods = mods + this.fieldTypeName.toShortString() + " ";
        if (this.declaringTypeName != null) {
            mods = mods + this.declaringTypeName.toShortString() + ".";
        }
        String ret = mods + this.id.toShortString();
        return ret;
    }

    public String getLookupId() {
        return this.id.getLookupString();
    }

    public FuzzyBoolean matches(JoinPoint jp) {
        if (!(jp.getTargetSO() instanceof Field)) {
            return FuzzyBoolean.NO;
        }
        Field m = (Field)jp.getTargetSO();
        if (!this.id.matches(m.getName())) {
            return FuzzyBoolean.NO;
        }
        if (!this.fieldTypeName.matches(m.getFieldType())) {
            return FuzzyBoolean.NO;
        }
        return super.matches(jp);
    }

    protected boolean isStaticMatch(SemanticObject so) {
        return true;
    }

    public GenTypeName getFieldTypeName() {
        return this.fieldTypeName;
    }

    public void setFieldTypeName(GenTypeName _fieldTypeName) {
        if (_fieldTypeName != null) {
            _fieldTypeName.setParent(this);
        }
        this.fieldTypeName = _fieldTypeName;
    }

    public NamePattern getId() {
        return this.id;
    }

    public void setId(NamePattern _id) {
        this.id = _id;
    }

    public FieldPattern(SourceLocation location, Modifiers _modifiers, GenTypeName _declaringTypeName, GenTypeName _fieldTypeName, NamePattern _id) {
        super(location, _modifiers, _declaringTypeName);
        this.setFieldTypeName(_fieldTypeName);
        this.setId(_id);
    }

    protected FieldPattern(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        FieldPattern ret = new FieldPattern(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.modifiers != null) {
            ret.setModifiers((Modifiers)walker.process(this.modifiers));
        }
        if (this.declaringTypeName != null) {
            ret.setDeclaringTypeName((GenTypeName)walker.process(this.declaringTypeName));
        }
        if (this.fieldTypeName != null) {
            ret.setFieldTypeName((GenTypeName)walker.process(this.fieldTypeName));
        }
        ret.id = this.id;
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 2: {
                return this.fieldTypeName;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 2: {
                return "fieldTypeName";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 2: {
                this.setFieldTypeName((GenTypeName)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 3;
    }

    public String getDefaultDisplayName() {
        return "FieldPattern(id: " + this.id + ")";
    }
}

