/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import java.util.Iterator;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.SemanticObject;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.crosscuts.ast.GenTypeName;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;
import org.aspectj.util.FuzzyBoolean;

public abstract class DecPattern
extends ASTObject {
    private boolean shownWarning = false;
    protected Modifiers modifiers;
    protected GenTypeName declaringTypeName;

    public abstract String toShortString();

    protected String makeDeclaringTypeString() {
        if (this.getDeclaringTypeName() == null) {
            return "";
        }
        return this.getDeclaringTypeName().toShortString() + '.';
    }

    public abstract String getLookupId();

    public FuzzyBoolean matches(JoinPoint jp) {
        if (!this.modifiers.matches(jp.getTargetSO().getModifiers())) {
            return FuzzyBoolean.NO;
        }
        if (this.getDeclaringTypeName() != null) {
            Type targetType = jp.getTargetType();
            if (targetType == null) {
                Iterator i = jp.getTargetTypes().iterator();
                while (i.hasNext()) {
                    targetType = (Type)i.next();
                    if (this.matchDeclaringTypeName(jp, targetType, jp.getTargetSO())) continue;
                    return FuzzyBoolean.NEVER;
                }
                return FuzzyBoolean.YES;
            }
            if (this.matchDeclaringTypeName(jp, jp.getTargetType(), jp.getTargetSO())) {
                return FuzzyBoolean.YES;
            }
            return FuzzyBoolean.NO;
        }
        return FuzzyBoolean.YES;
    }

    protected boolean isStaticMatch(SemanticObject so) {
        return so.isStatic();
    }

    boolean matchDeclaringTypeName(JoinPoint joinPoint, Type inType, SemanticObject so) {
        SemanticObject matchingSO = inType.findMatchingSemanticObject(so);
        if (matchingSO == null) {
            return false;
        }
        if (this.isStaticMatch(so) && matchingSO != so) {
            return false;
        }
        if (this.getDeclaringTypeName().matches(inType)) {
            return true;
        }
        Iterator i = inType.getDirectSuperTypes().iterator();
        while (i.hasNext()) {
            if (!this.matchDeclaringTypeName(joinPoint, (Type)i.next(), so)) continue;
            return true;
        }
        return false;
    }

    public Modifiers getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(Modifiers _modifiers) {
        if (_modifiers != null) {
            _modifiers.setParent(this);
        }
        this.modifiers = _modifiers;
    }

    public GenTypeName getDeclaringTypeName() {
        return this.declaringTypeName;
    }

    public void setDeclaringTypeName(GenTypeName _declaringTypeName) {
        if (_declaringTypeName != null) {
            _declaringTypeName.setParent(this);
        }
        this.declaringTypeName = _declaringTypeName;
    }

    public DecPattern(SourceLocation location, Modifiers _modifiers, GenTypeName _declaringTypeName) {
        super(location);
        this.setModifiers(_modifiers);
        this.setDeclaringTypeName(_declaringTypeName);
    }

    protected DecPattern(SourceLocation source) {
        super(source);
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.modifiers;
            }
            case 1: {
                return this.declaringTypeName;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "modifiers";
            }
            case 1: {
                return "declaringTypeName";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setModifiers((Modifiers)child);
                return;
            }
            case 1: {
                this.setDeclaringTypeName((GenTypeName)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 2;
    }

    public String getDefaultDisplayName() {
        return "DecPattern()";
    }
}

