/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CallExpr;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.FormalDec;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.ScopeWalker;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Stmts;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.ast.VarDec;
import org.aspectj.compiler.base.ast.Walker;
import org.aspectj.compiler.crosscuts.ast.CFlowPlanner;
import org.aspectj.compiler.crosscuts.ast.Pcd;
import org.aspectj.compiler.crosscuts.ast.PlanData;
import org.aspectj.compiler.crosscuts.ast.VarTypeName;
import org.aspectj.compiler.crosscuts.joinpoints.CFlowEntryPlan;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlan;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlanner;
import org.aspectj.compiler.crosscuts.joinpoints.WrappedJpPlanner;
import org.aspectj.util.FuzzyBoolean;

public class CFlowPcd
extends Pcd {
    List flowState = null;
    Map cflowFields = new HashMap();
    private static int counter = 0;
    private static int ecounter = 0;
    protected Pcd pcd;
    protected boolean includesRoot;

    public String toShortString() {
        return "cflow" + (this.includesRoot ? "below" : "") + "(" + this.getPcd().toShortString() + ")";
    }

    public void checkStatic() {
        this.showNonStaticError();
    }

    public JpPlanner makePlanner(PlanData planData) {
        this.findFlowState();
        Map extraPlanners = planData.inAspect.getExtraPlanners();
        if (!extraPlanners.containsKey(this)) {
            extraPlanners.put(this, this.makeEntryPointInitializer(planData));
        }
        final CflowField field = this.getCflowField(planData.inAspect);
        return new JpPlanner(){

            public FuzzyBoolean fastMatch(JoinPoint jp) {
                return FuzzyBoolean.MAYBE;
            }

            public JpPlan makePlan(JoinPoint jp) {
                JpPlan plan = new JpPlan(jp);
                plan.test = field.testStackExpr();
                plan.addDependency(field);
                field.remapExprs(plan);
                return plan;
            }
        };
    }

    private JpPlanner makeEntryPointInitializer(PlanData planData) {
        this.findFlowState();
        JpPlanner planner = this.getPcd().makePlanner(planData);
        final CflowField field = this.getCflowField(planData.inAspect);
        return new WrappedJpPlanner(planner){

            public JpPlan makePlan(JoinPoint jp) {
                JpPlan plan = super.makePlan(jp);
                if (!plan.isPossible()) {
                    return plan;
                }
                return new CFlowEntryPlan(plan, field);
            }
        };
    }

    public ASTObject postScope(ScopeWalker walker) {
        if (walker.walkBodies()) {
            this.findFlowState();
        }
        return this;
    }

    void findFlowState() {
        if (this.flowState != null) {
            return;
        }
        this.flowState = new ArrayList();
        new Walker(this.getCompiler()){

            public void postProcess(ASTObject node) {
                VarTypeName varTypeName;
                if (node instanceof VarTypeName && (varTypeName = (VarTypeName)node).getFormalDec() != null) {
                    CFlowPcd.this.addFlowState(varTypeName);
                }
            }
        }.process(this.getPcd());
    }

    void addFlowState(VarTypeName varTypeName) {
        this.flowState.add(varTypeName);
    }

    public CflowField getCflowField(TypeDec inTypeDec) {
        CflowField ret = (CflowField)this.cflowFields.get(inTypeDec);
        if (ret == null) {
            ret = new CflowField(inTypeDec);
            this.cflowFields.put(inTypeDec, ret);
        }
        return ret;
    }

    public Pcd getPcd() {
        return this.pcd;
    }

    public void setPcd(Pcd _pcd) {
        if (_pcd != null) {
            _pcd.setParent(this);
        }
        this.pcd = _pcd;
    }

    public boolean getIncludesRoot() {
        return this.includesRoot;
    }

    public void setIncludesRoot(boolean _includesRoot) {
        this.includesRoot = _includesRoot;
    }

    public CFlowPcd(SourceLocation location, Pcd _pcd, boolean _includesRoot) {
        super(location);
        this.setPcd(_pcd);
        this.setIncludesRoot(_includesRoot);
    }

    protected CFlowPcd(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        CFlowPcd ret = new CFlowPcd(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.pcd != null) {
            ret.setPcd((Pcd)walker.process(this.pcd));
        }
        ret.includesRoot = this.includesRoot;
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.pcd;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "pcd";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setPcd((Pcd)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 1;
    }

    public String getDefaultDisplayName() {
        return "CFlowPcd(includesRoot: " + this.includesRoot + ")";
    }

    class CflowField
    implements CFlowPlanner {
        private TypeDec declaringTypeDec = null;
        private FieldDec stack;

        public CflowField(TypeDec inTypeDec) {
            this.declaringTypeDec = inTypeDec;
        }

        public boolean getIncludesRoot() {
            return CFlowPcd.this.getIncludesRoot();
        }

        FieldDec getStackField() {
            if (this.stack != null) {
                return this.stack;
            }
            AST ast = CFlowPcd.this.getAST();
            String name = "cflow$ajc" + counter++;
            Type type = CFlowPcd.this.getTypeManager().getType("org.aspectj.runtime.internal", "CFlowStack");
            Modifiers modifiers = ast.makeModifiers(25);
            this.stack = ast.makeField(modifiers, type, name, ast.makeNew(type));
            this.declaringTypeDec.getBody().add(0, this.stack);
            return this.stack;
        }

        Expr getStackVar() {
            return CFlowPcd.this.getAST().makeGet(this.getStackField());
        }

        Expr testStackExpr() {
            return CFlowPcd.this.getAST().makeCall(this.getStackVar(), "isValid");
        }

        Expr pushStackExpr(Expr expr) {
            return CFlowPcd.this.getAST().makeCall(this.getStackVar(), "push", expr);
        }

        Expr popStackExpr() {
            return CFlowPcd.this.getAST().makeCall(this.getStackVar(), "pop");
        }

        Expr peekStackExpr() {
            return CFlowPcd.this.getAST().makeCall(this.getStackVar(), "peekCFlow");
        }

        void remapExprs(JpPlan plan) {
            int index = 0;
            Iterator i = CFlowPcd.this.flowState.iterator();
            while (i.hasNext()) {
                VarTypeName varTypeName = (VarTypeName)i.next();
                FormalDec formal = varTypeName.getFormalDec();
                Expr expr = this.makeFlowStateExpr(formal.getType(), index++);
                plan.bindExpr(varTypeName.getFormalDec(), expr);
            }
        }

        public Stmts wrapPushPop(JpPlan plan, Stmts body) {
            AST ast = CFlowPcd.this.getAST();
            Expr newCFlowExpr = this.makeNewCFlowExpr(plan);
            Expr test = plan.getDynamicTest();
            if (test == null) {
                return ast.makeStmts(ast.makeStmt(this.pushStackExpr(newCFlowExpr)), ast.makeTryFinally(ast.makeBlock(body), ast.makeBlock(this.popStackExpr())));
            }
            VarDec tmp = ast.makeFinalVar(CFlowPcd.this.getTypeManager().booleanType, "ajc_enter_cflow_" + ecounter++, test);
            return ast.makeStmts(tmp, ast.makeIf(ast.makeVar(tmp), ast.makeStmt(this.pushStackExpr(newCFlowExpr))), ast.makeTryFinally(ast.makeBlock(body), ast.makeBlock(ast.makeIf(ast.makeVar(tmp), ast.makeStmt(this.popStackExpr())))));
        }

        Exprs initializeFlowState(JpPlan plan) {
            AST ast = CFlowPcd.this.getAST();
            boolean index = false;
            Exprs stateExprs = ast.makeExprs();
            Iterator i = CFlowPcd.this.flowState.iterator();
            while (i.hasNext()) {
                VarTypeName varTypeName = (VarTypeName)i.next();
                FormalDec formal = varTypeName.getFormalDec();
                Expr expr = (Expr)plan.bindings.get(formal);
                if (expr == null) {
                    varTypeName.showError("no binding for this variable in enclosing cflow");
                }
                expr = expr.getType().makeObject(expr);
                stateExprs.add(expr);
            }
            Exprs ret = ast.makeExprs();
            if (stateExprs.size() == 0) {
                return null;
            }
            ret.add(ast.makeObjectArray(stateExprs));
            return ret;
        }

        Expr makeFlowStateExpr(Type desiredType, int index) {
            CallExpr objectExpr = CFlowPcd.this.getAST().makeCall(this.peekStackExpr(), "get", (Expr)CFlowPcd.this.getAST().makeLiteral(index));
            return desiredType.fromObject(objectExpr);
        }

        public Expr makeNewCFlow(Exprs baseExprs) {
            Type cflowType;
            if (baseExprs == null) {
                baseExprs = CFlowPcd.this.getAST().makeExprs();
                cflowType = CFlowPcd.this.getTypeManager().getType("org.aspectj.runtime", "CFlow");
            } else {
                cflowType = CFlowPcd.this.getTypeManager().getType("org.aspectj.runtime.internal", "CFlowPlusState");
            }
            return CFlowPcd.this.getAST().makeNew(cflowType, baseExprs);
        }

        public Expr makeNewCFlowExpr(JpPlan plan) {
            return this.makeNewCFlow(this.initializeFlowState(plan));
        }
    }
}

