/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts;

import java.util.List;
import org.aspectj.compiler.base.AbstractCompilerPass;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.CompilationUnit;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.Decs;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.crosscuts.AccessFixer;
import org.aspectj.compiler.crosscuts.ast.AspectDec;

public class PrivilegeFixer
extends AbstractCompilerPass {
    private boolean apply;

    public PrivilegeFixer(JavaCompiler compiler, boolean apply) {
        super(compiler);
        this.apply = apply;
    }

    public String getDisplayName() {
        return (this.apply ? "implement" : "plan") + " backdoors";
    }

    public void transform(TypeDec td) {
        AccessFixer fixer = new AccessFixer(this.getCompiler(), td, this.apply);
        fixer.fixAccesses(td);
    }

    private void checkTypeDecs(CompilationUnit cu, boolean apply) {
        List typeDecs = cu.getDefinedTypes();
        int N = typeDecs.size();
        int j = 0;
        while (j < N) {
            Dec dec = (Dec)typeDecs.get(j);
            if (dec instanceof TypeDec) {
                TypeDec typeDec = (TypeDec)dec;
                if (typeDec instanceof AspectDec && typeDec.getModifiers().isPrivileged()) {
                    AccessFixer fixer = new AccessFixer(this.getCompiler(), typeDec, apply);
                    fixer.fixAccesses(typeDec);
                }
                this.fixIntroducedDecs(typeDec, apply);
            }
            ++j;
        }
    }

    private void fixIntroducedDecs(TypeDec typeDec, boolean apply) {
        Decs decs = typeDec.getBody();
        int i = 0;
        while (i < decs.size()) {
            Dec dec = decs.get(i);
            if (dec.isIntroduced()) {
                new AccessFixer(this.getCompiler(), typeDec, apply).fixAccesses(dec);
            }
            ++i;
        }
    }
}

