/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.aspectj.compiler.base.CompilerObject;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.ClassDec;
import org.aspectj.compiler.base.ast.CodeDec;
import org.aspectj.compiler.base.ast.CompilationUnit;
import org.aspectj.compiler.base.ast.ConstructorDec;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.Decs;
import org.aspectj.compiler.base.ast.InitializerDec;
import org.aspectj.compiler.base.ast.InterfaceDec;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.ast.VarDec;
import org.aspectj.compiler.crosscuts.ast.AdviceDec;
import org.aspectj.compiler.crosscuts.ast.AspectDec;
import org.aspectj.compiler.crosscuts.ast.IntroducedDec;
import org.aspectj.compiler.crosscuts.ast.IntroducedSuperDec;
import org.aspectj.compiler.crosscuts.ast.NamePcd;
import org.aspectj.compiler.crosscuts.ast.Pcd;
import org.aspectj.compiler.crosscuts.ast.PointcutDec;
import org.aspectj.tools.ide.Declaration;
import org.aspectj.util.CollectionUtil;

class CompilationUnitCorrespondences
extends CompilerObject {
    private CompilationUnit compilationUnit;
    private Map pointsTo = new HashMap();
    private Map pointedToBy = new HashMap();

    public CompilationUnitCorrespondences(CompilationUnit cu) {
        super(cu.getCompiler());
        this.compilationUnit = cu;
    }

    public Set getPointsToSet(ASTObject fromNode) {
        return CollectionUtil.getSetInMap(this.pointsTo, fromNode);
    }

    public Set getPointedToBySet(ASTObject fromNode) {
        return CollectionUtil.getSetInMap(this.pointedToBy, fromNode);
    }

    public void addPointsTo(ASTObject fromNode, ASTObject toNode) {
        CollectionUtil.getSetInMap(this.pointsTo, fromNode).add(toNode);
    }

    public void addPointedToBy(ASTObject toNode, ASTObject fromNode) {
        CollectionUtil.getSetInMap(this.pointedToBy, toNode).add(fromNode);
    }

    private String quoteString(String s) {
        return "\"" + s + "\" ";
    }

    private String getKind(ASTObject node) {
        if (node instanceof TypeDec) {
            TypeDec typeDec = (TypeDec)node;
            if (typeDec instanceof InterfaceDec) {
                return "interface";
            }
            if (typeDec instanceof ClassDec) {
                return "class";
            }
            if (typeDec instanceof AspectDec) {
                return "aspect";
            }
        }
        if (node instanceof VarDec) {
            return "field";
        }
        if (node instanceof InitializerDec) {
            return "initializer";
        }
        if (node instanceof ConstructorDec) {
            return "constructor";
        }
        if (node instanceof MethodDec) {
            return "method";
        }
        if (node instanceof IntroducedDec) {
            return "introduction";
        }
        if (node instanceof IntroducedSuperDec) {
            return "introduction";
        }
        if (node instanceof AdviceDec) {
            return "advice";
        }
        if (node instanceof PointcutDec) {
            return "pointcut";
        }
        return "unknown";
    }

    private String getDeclaringType(ASTObject node) {
        Type declaringType = node.getDeclaringType();
        if (declaringType == null) {
            return null;
        }
        return declaringType.getTypeDec().getExtendedId().replace('$', '.');
    }

    private String getSignature(ASTObject node) {
        if (node instanceof TypeDec) {
            return ((TypeDec)node).getId();
        }
        if (node instanceof PointcutDec) {
            PointcutDec ccDec = (PointcutDec)node;
            String name = ccDec.getName();
            return name + ccDec.getFormals().toShortString();
        }
        if (node instanceof AdviceDec) {
            AdviceDec aDec = (AdviceDec)node;
            return aDec.toShortString();
        }
        if (node instanceof VarDec) {
            return ((VarDec)node).getName();
        }
        if (node instanceof CodeDec) {
            CodeDec codeDec = (CodeDec)node;
            String name = codeDec.getName();
            if (name.equals("<init>")) {
                name = this.getDeclaringType(node);
            }
            return name + codeDec.getFormals().toShortString();
        }
        if (node instanceof IntroducedDec) {
            IntroducedDec idec = (IntroducedDec)node;
            return idec.getTargets().toShortString() + "." + this.getSignature(idec.getDec());
        }
        if (node instanceof IntroducedSuperDec) {
            IntroducedSuperDec idec = (IntroducedSuperDec)node;
            return idec.getTargets().toShortString() + "+" + (idec.getIsImplements() ? "implements" : "extends");
        }
        return "...";
    }

    public String trimSig(String sig) {
        int index = sig.length() - 1;
        while (index > 0) {
            char ch = sig.charAt(index);
            if (ch != '{' && ch != '}' && ch != ';' && !Character.isWhitespace(ch)) break;
            --index;
        }
        return sig.substring(0, index + 1);
    }

    public String getModifiers(ASTObject node) {
        if (node instanceof IntroducedDec) {
            return ((IntroducedDec)node).getDec().getModifiers().toShortString();
        }
        if (node instanceof Dec) {
            return ((Dec)node).getModifiers().toShortString();
        }
        return "";
    }

    public Pcd getPcd(ASTObject node) {
        if (node instanceof AdviceDec) {
            AdviceDec adviceDec = (AdviceDec)node;
            return adviceDec.getPcd();
        }
        if (node instanceof PointcutDec) {
            return ((PointcutDec)node).getPcd();
        }
        return null;
    }

    public String getPcdString(ASTObject node) {
        Pcd cc = this.getPcd(node);
        if (cc == null) {
            return null;
        }
        return cc.toShortString();
    }

    public Declaration getPointcutDeclaration(ASTObject node) {
        Pcd cc = this.getPcd(node);
        if (cc == null) {
            return null;
        }
        if (!(cc instanceof NamePcd)) {
            return null;
        }
        NamePcd nameCC = (NamePcd)cc;
        return this.makeBaseDeclaration(nameCC.getPointcutDec());
    }

    public String getFullSignature(ASTObject node) {
        if (node instanceof Dec) {
            Dec dec = (Dec)node;
            return dec.getSignatureString();
        }
        return null;
    }

    public void doIndent(Writer writer, int size) throws IOException {
        int i = 0;
        while (i < size) {
            writer.write(" ");
            ++i;
        }
    }

    public Declaration makeBaseDeclaration(ASTObject node) {
        if (node == null) {
            return null;
        }
        if (node instanceof InitializerDec) {
            return null;
        }
        if (node instanceof Dec && ((Dec)node).isIntroduced()) {
            return null;
        }
        String kindPrefix = "";
        if (node.getSourceFile() == null) {
            return null;
        }
        Declaration dec = new Declaration(node.getBeginLine(), node.getEndLine(), node.getBeginColumn(), node.getEndColumn(), this.getModifiers(node), this.getSignature(node), this.getFullSignature(node), this.getPcdString(node), this.getDeclaringType(node), kindPrefix + this.getKind(node), node.getSourceFile().getAbsolutePath(), node.getFormalComment(), node.getCompilationUnit().getPackageName());
        dec.setCrosscutDeclaration(this.getPointcutDeclaration(node));
        return dec;
    }

    private Declaration[] makeDeclarations(Collection nodes) {
        if (nodes == null) {
            return new Declaration[0];
        }
        ArrayList<Declaration> newDeclarations = new ArrayList<Declaration>();
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            Declaration dec = this.makeBaseDeclaration((ASTObject)iter.next());
            if (dec == null) continue;
            newDeclarations.add(dec);
        }
        return newDeclarations.toArray(new Declaration[0]);
    }

    private Declaration[] decsToDeclarations(Decs decs) {
        if (decs == null) {
            return new Declaration[0];
        }
        ArrayList<Declaration> newDeclarations = new ArrayList<Declaration>();
        int i = 0;
        while (i < decs.size()) {
            Declaration dec;
            if (decs.get(i).isLanguageVisible() && (dec = this.makeDeclaration(decs.get(i))) != null) {
                newDeclarations.add(dec);
            }
            ++i;
        }
        return newDeclarations.toArray(new Declaration[newDeclarations.size()]);
    }

    private Declaration makeDeclaration(ASTObject node) {
        Declaration declaration = this.makeBaseDeclaration(node);
        if (declaration == null) {
            return null;
        }
        declaration.setPointsTo(this.makeDeclarations((Collection)this.pointsTo.get(node)));
        declaration.setPointedToBy(this.makeDeclarations((Collection)this.pointedToBy.get(node)));
        if (node instanceof TypeDec) {
            Decs enclosedDecs = ((TypeDec)node).getBody();
            declaration.setDeclarations(this.decsToDeclarations(enclosedDecs));
        }
        return declaration;
    }

    public void dumpSymbolFile(OutputStream stream) throws IOException {
        Declaration[] declarations = this.decsToDeclarations(this.compilationUnit.getDecs());
        ObjectOutputStream objectStream = new ObjectOutputStream(stream);
        objectStream.writeObject(declarations);
        objectStream.close();
    }
}

