/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts;

import java.util.Collection;
import java.util.Iterator;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.WalkerPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;

public class AdviceWeaver
extends WalkerPass {
    public AdviceWeaver(JavaCompiler compiler) {
        super(compiler);
    }

    public String getDisplayName() {
        return "weaving advice";
    }

    protected void postProcess(ASTObject object) {
        if (object instanceof TypeDec) {
            this.weaveInto((TypeDec)object);
        }
    }

    public void weaveInto(TypeDec typeDec) {
        this.getCompiler().showMessage("    weaving into " + typeDec.toShortString());
        this.applyAspectsOf(typeDec);
        this.implementPlans(typeDec.joinPoints0);
        this.implementPlans(typeDec.joinPoints1);
        this.implementPlans(typeDec.joinPoints2, typeDec.getInitializerExecutionJoinPoints());
        this.implementPlans(typeDec.getInitializerExecutionJoinPoints());
    }

    void applyAspectsOf(TypeDec typeDec) {
        this.getWorld().runTypeDecPlanners(typeDec, 3);
    }

    void implementPlans(Collection jps) {
        this.implementPlans(jps, null);
    }

    void implementPlans(Collection jps, Collection skipSet) {
        Iterator i = jps.iterator();
        while (i.hasNext()) {
            JoinPoint joinPoint = (JoinPoint)i.next();
            if (skipSet != null && skipSet.contains(joinPoint)) continue;
            joinPoint.implementPlans();
        }
    }
}

