/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.parser;

import java.io.File;
import java.util.Arrays;
import org.aspectj.util.IntList;

public class SourceInfo {
    private File file;
    private int[] lineStarts;
    private char[] text;

    public SourceInfo(File _file, char[] _text) {
        this.file = _file;
        this.setText(_text);
    }

    public void setText(char[] text) {
        this.text = text;
        if (text != null) {
            this.lineStarts = this.findNewLines(text);
        }
    }

    private int[] findNewLines(char[] text) {
        IntList lineStarts = new IntList();
        lineStarts.add(0);
        int N = text.length;
        int i = 0;
        while (i < N) {
            int ch = text[i];
            if (ch == 13) {
                if (i < N - 1 && text[i + 1] == '\n') {
                    text[i] = 32;
                } else {
                    text[i] = 10;
                    ch = 10;
                }
            }
            if (ch == 10) {
                lineStarts.add(i + 1);
            }
            ++i;
        }
        lineStarts.add(N + 100);
        return lineStarts.toIntArray();
    }

    public File getFile() {
        return this.file;
    }

    public int getLine(int position) {
        if (this.lineStarts == null) {
            return -1;
        }
        int pos = Arrays.binarySearch(this.lineStarts, position);
        if (pos >= 0) {
            return pos + 1;
        }
        return -pos - 1;
    }

    public int getColumn(int position) {
        if (this.lineStarts == null) {
            return -1;
        }
        int line = 1;
        while (line < this.lineStarts.length) {
            if (this.lineStarts[line] > position) break;
            ++line;
        }
        return position - this.lineStarts[line - 1] + 1;
    }
}

