/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.parser;

import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.LongLiteralExpr;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.parser.Literal;

class LongLiteral
extends Literal {
    public int radix;

    public LongLiteral(String image, int radix) {
        super(image, 13);
        this.radix = radix;
    }

    public String toString() {
        return "LongLiteral(" + this.image + ")";
    }

    public long parseLong(SourceLocation source, boolean negative) {
        long ret = 0L;
        String s = this.image;
        if (this.radix == 10) {
            try {
                if (negative) {
                    s = "-" + s;
                }
                ret = Long.parseLong(s, this.radix);
            }
            catch (NumberFormatException nfe) {
                source.showError("invalid long decimal literal");
            }
        } else {
            int N = s.length();
            if (N == 0 && this.radix == 16) {
                source.showError("0x must be followed by digits");
            }
            int shift = this.radix == 16 ? 4 : 3;
            long limit = -1L >>> shift ^ 0xFFFFFFFFFFFFFFFFL;
            int i = 0;
            while (i < N) {
                if ((ret & limit) != 0L) {
                    source.showError("long literals must be no more than 64-bit");
                    break;
                }
                ret <<= shift;
                int digit = Character.digit(s.charAt(i), this.radix);
                ret |= (long)digit;
                ++i;
            }
            if (negative) {
                ret = -ret;
            }
        }
        return ret;
    }

    public Expr getExpr(SourceLocation source) {
        return new LongLiteralExpr(source, this.parseLong(source, false));
    }

    public Expr getNegativeExpr(SourceLocation source) {
        return new LongLiteralExpr(source, this.parseLong(source, true));
    }
}

