/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.parser;

import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.IntLiteralExpr;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.parser.Literal;

class IntegerLiteral
extends Literal {
    public int radix;

    public IntegerLiteral(String image, int radix) {
        super(image, 13);
        this.radix = radix;
    }

    public String toString() {
        return "IntegerLiteral(" + this.image + ")";
    }

    public int parseInt(SourceLocation source, boolean negative) {
        int ret = 0;
        String s = this.image;
        if (this.radix == 10) {
            if (s.length() > 1 && s.charAt(0) == '0') {
                source.showError("invalid octal literal");
                return 0;
            }
            try {
                if (negative) {
                    s = "-" + s;
                }
                ret = Integer.parseInt(s, this.radix);
            }
            catch (NumberFormatException nfe) {
                source.showError("invalid int decimal literal");
            }
        } else {
            int N = s.length();
            if (N == 0 && this.radix == 16) {
                source.showError("0x must be followed by digits");
            }
            int shift = this.radix == 16 ? 4 : 3;
            int limit = ~(-1 >>> shift);
            int i = 0;
            while (i < N) {
                if ((ret & limit) != 0) {
                    source.showError("integer literal must be no more than 32-bit");
                    break;
                }
                ret <<= shift;
                int digit = Character.digit(s.charAt(i), this.radix);
                ret |= digit;
                ++i;
            }
            if (negative) {
                ret = -ret;
            }
        }
        return ret;
    }

    public Expr getExpr(SourceLocation source) {
        return new IntLiteralExpr(source, this.parseInt(source, false));
    }

    public Expr getNegativeExpr(SourceLocation source) {
        return new IntLiteralExpr(source, this.parseInt(source, true));
    }
}

