/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.parser;

import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.IntLiteralExpr;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.parser.Literal;

class CharacterLiteral
extends Literal {
    public char value;

    public CharacterLiteral(char value) {
        super("\"" + value + "\"", 19);
        this.value = value;
    }

    public static void quoteCharacter(char ch, StringBuffer buf) {
        switch (ch) {
            case '\b': {
                buf.append("\\b");
                return;
            }
            case '\t': {
                buf.append("\\t");
                return;
            }
            case '\n': {
                buf.append("\\n");
                return;
            }
            case '\f': {
                buf.append("\\f");
                return;
            }
            case '\r': {
                buf.append("\\r");
                return;
            }
            case '\"': {
                buf.append("\\\"");
                return;
            }
            case '\'': {
                buf.append("\\'");
                return;
            }
            case '\\': {
                buf.append("\\\\");
                return;
            }
        }
        buf.append(ch);
    }

    public String toJavaSource() {
        StringBuffer buf = new StringBuffer("'");
        CharacterLiteral.quoteCharacter(this.value, buf);
        buf.append("'");
        return buf.toString();
    }

    public Expr getExpr(SourceLocation source) {
        return new IntLiteralExpr(source, source.getCompiler().getTypeManager().charType, this.toJavaSource(), this.value);
    }
}

