/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.cst;

import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Field;
import org.aspectj.compiler.base.ast.FieldAccessExpr;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.cst.Scope;

public class TypeScope
extends Scope {
    private Type type;

    public TypeScope(JavaCompiler compiler, Scope parent, Type type) {
        super(compiler, parent);
        this.type = type;
    }

    public String shortToString() {
        return "TYPE(" + this.type.getString() + ")";
    }

    public Type findType(String name, ASTObject fromWhere) {
        Type ret = this.type.getInnerType(name, fromWhere, false);
        if (ret != this.getTypeManager().TYPE_NOT_FOUND && ret != null) {
            return ret;
        }
        return super.findType(name, fromWhere);
    }

    public Expr bindUnqualifiedName(String name, ASTObject fromWhere) {
        Field ret = this.type.getField(name, fromWhere, false);
        if (ret != null) {
            Expr thisExpr = ret.isStatic() ? this.getAST().makeTypeExpr(this.type) : this.getAST().makeQualifiedThis(this.type);
            return new FieldAccessExpr(fromWhere.getSourceLocation(), thisExpr, ret, false);
        }
        return super.bindUnqualifiedName(name, fromWhere);
    }

    public Type findMethodLookupType(String name, ASTObject fromWhere) {
        if (this.type.hasMethodNamed(name)) {
            return this.type;
        }
        return super.findMethodLookupType(name, fromWhere);
    }
}

