/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.cst;

import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Field;
import org.aspectj.compiler.base.ast.FieldAccessExpr;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeExpr;
import org.aspectj.compiler.base.cst.Scope;

public class Name
extends ASTObject {
    boolean allowType = true;
    protected Name parentName;
    protected String id;
    protected boolean allowExpr;

    public Name(SourceLocation location, Name parentName, String id) {
        this(location, parentName, id, true);
    }

    public void forceType() {
        this.allowExpr = false;
        if (this.parentName != null) {
            this.parentName.forceType();
        }
    }

    private Object resolveSimple(Scope scope, boolean showError) {
        if (this.allowExpr) {
            Expr expr = scope.bindUnqualifiedName(this.id, this);
            if (expr != null) {
                expr.setSourceLocation(this.getSourceLocation());
                return expr;
            }
            if (showError) {
                this.showError("can't bind name: " + this.id);
            }
        }
        if (this.allowType) {
            Type type = scope.findType(this.id, this);
            if (type != null) {
                return type;
            }
            if (type == null && showError && !this.allowExpr) {
                this.showError("type name not found: " + this.id);
            }
        }
        return this.id;
    }

    private Object resolve1(Expr parentExpr, boolean showError) {
        Field field = parentExpr.getType().getField(this.id, this, showError);
        FieldAccessExpr ret = this.getAST().makeGet(parentExpr, field);
        ret.setSourceLocation(this.getSourceLocation());
        return ret;
    }

    private Object resolve1(String parentPackage, boolean showError) {
        Type type = this.getTypeManager().findType(parentPackage, this.id);
        if (type == null) {
            return parentPackage + '.' + this.id;
        }
        return type;
    }

    private Object resolve1(Type parentType, boolean showError) {
        Type type;
        Field field;
        if (this.allowExpr && (field = parentType.getField(this.id, this, false)) != null) {
            TypeExpr typeExpr = this.getAST().makeTypeExpr(parentType);
            typeExpr.setSourceLocation(this.parentName.getSourceLocation());
            FieldAccessExpr ret = this.getAST().makeGet((Expr)typeExpr, field);
            ret.setSourceLocation(this.getSourceLocation());
            return ret;
        }
        if (this.allowType && (type = parentType.getInnerType(this.id, this, false)) != this.getTypeManager().TYPE_NOT_FOUND) {
            return type;
        }
        if (!showError) {
            return null;
        }
        if (this.allowExpr && this.allowType) {
            return this.getAST().makeGet(null, parentType.getField(this.id, this, true));
        }
        if (this.allowType && !this.allowExpr) {
            if (parentType.getField(this.id, this, false) != null) {
                this.showError("type required, but field found: " + this.id);
                return this.getTypeManager().TYPE_NOT_FOUND;
            }
            return parentType.getInnerType(this.id, this, true);
        }
        this.showError("name not found: " + this.id);
        return null;
    }

    public Type resolveType(Scope scope) {
        return this.resolveType(scope, true);
    }

    public Type resolveType(Scope scope, boolean showError) {
        this.forceType();
        Object ret = this.internalResolve(scope, showError);
        if (ret instanceof Type) {
            return (Type)ret;
        }
        if (showError) {
            this.showNiceError(scope);
        }
        return this.getTypeManager().TYPE_NOT_FOUND;
    }

    public Expr resolveExpr(Scope scope) {
        Object ret = this.internalResolve(scope, true);
        if (ret instanceof Expr) {
            return (Expr)ret;
        }
        if (ret instanceof Type) {
            TypeExpr expr = this.getAST().makeTypeExpr((Type)ret);
            expr.setSourceLocation(this.getSourceLocation());
            return expr;
        }
        this.showNiceError(scope);
        return this.getAST().makeNotFoundExpr();
    }

    private void showNiceError(Scope scope) {
        if (this.parentName == null) {
            this.resolveSimple(scope, true);
        } else {
            this.showError("can't bind name: " + this.toString());
        }
    }

    public Object resolve(Scope scope, boolean showError) {
        return this.internalResolve(scope, showError);
    }

    private final Object internalResolve(Scope scope, boolean showError) {
        if (this.parentName == null) {
            return this.resolveSimple(scope, false);
        }
        Object parentO = this.parentName.internalResolve(scope, showError);
        if (parentO == null) {
            return null;
        }
        if (parentO instanceof Type) {
            return this.resolve1((Type)parentO, showError);
        }
        if (parentO instanceof String) {
            return this.resolve1((String)parentO, showError);
        }
        return this.resolve1((Expr)parentO, showError);
    }

    public String toString() {
        if (this.parentName == null) {
            return this.id;
        }
        return this.parentName.toString() + '.' + this.id;
    }

    public Name getParentName() {
        return this.parentName;
    }

    public void setParentName(Name _parentName) {
        if (_parentName != null) {
            _parentName.setParent(this);
        }
        this.parentName = _parentName;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String _id) {
        this.id = _id;
    }

    public boolean getAllowExpr() {
        return this.allowExpr;
    }

    public void setAllowExpr(boolean _allowExpr) {
        this.allowExpr = _allowExpr;
    }

    public Name(SourceLocation location, Name _parentName, String _id, boolean _allowExpr) {
        super(location);
        this.setParentName(_parentName);
        this.setId(_id);
        this.setAllowExpr(_allowExpr);
    }

    protected Name(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        Name ret = new Name(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.parentName != null) {
            ret.setParentName((Name)walker.process(this.parentName));
        }
        ret.id = this.id;
        ret.allowExpr = this.allowExpr;
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.parentName;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "parentName";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setParentName((Name)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 1;
    }

    public String getDefaultDisplayName() {
        return "Name(id: " + this.id + ", " + "allowExpr: " + this.allowExpr + ")";
    }
}

