/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.bytecode;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.bytecode.ClassManager;
import org.aspectj.compiler.base.bytecode.DirectoryClassManager;
import org.aspectj.compiler.base.bytecode.JarClassManager;

public class ClassPathManager
extends ClassManager {
    List classManagers;

    private ClassPathManager(JavaCompiler compiler, List classManagers) {
        super(compiler);
        this.classManagers = classManagers;
    }

    public ClassPathManager(JavaCompiler compiler, String classpath, String bootclasspath, String extdirs) {
        super(compiler);
        LinkedList managers = new LinkedList();
        if (bootclasspath == null) {
            bootclasspath = System.getProperty("sun.boot.class.path", "");
        }
        this.addClasspathManagers(managers, bootclasspath);
        if (extdirs == null) {
            extdirs = System.getProperty("java.ext.dirs", "");
        }
        this.addExtensionManagers(managers, extdirs);
        if (classpath == null) {
            classpath = System.getProperty("java.class.path", "");
        }
        this.addClasspathManagers(managers, classpath);
        this.classManagers = managers;
    }

    protected void addClasspathManagers(List managers, String classpath) {
        StringTokenizer tok = new StringTokenizer(classpath, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            String entry = tok.nextToken().trim();
            if (entry.endsWith(".jar") || entry.endsWith(".zip")) {
                managers.add(new JarClassManager(this.getCompiler(), new File(entry)));
                continue;
            }
            managers.add(new DirectoryClassManager(this.getCompiler(), new File(entry)));
        }
    }

    protected void addExtensionManagers(List managers, String extdirs) {
        StringTokenizer tok = new StringTokenizer(extdirs, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            String entry = tok.nextToken().trim();
            this.addExtensionDirManagers(managers, new File(entry));
        }
    }

    protected void addExtensionDirManagers(List managers, File extdir) {
        if (!extdir.isDirectory()) {
            return;
        }
        String[] names = extdir.list();
        if (names == null) {
            return;
        }
        int i = 0;
        while (i < names.length) {
            File file;
            if ((names[i].endsWith(".jar") || names[i].endsWith(".zip")) && (file = new File(extdir, names[i])).isFile()) {
                managers.add(new JarClassManager(this.getCompiler(), file));
            }
            ++i;
        }
    }

    private String join(String[] names) {
        StringBuffer buf = new StringBuffer();
        buf.append(names[0]);
        int i = 1;
        while (i < names.length) {
            buf.append('.');
            buf.append(names[i]);
            ++i;
        }
        return buf.toString();
    }

    public TypeDec findTypeDec(String name) {
        Iterator i = this.classManagers.iterator();
        while (i.hasNext()) {
            ClassManager cm = (ClassManager)i.next();
            TypeDec ret = cm.findTypeDec(name);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public ClassManager makeSubPackageManager(String subPackageName) {
        LinkedList<ClassManager> ret = new LinkedList<ClassManager>();
        Iterator i = this.classManagers.iterator();
        while (i.hasNext()) {
            ClassManager cm = (ClassManager)i.next();
            ClassManager newCM = cm.makeSubPackageManager(subPackageName);
            if (newCM == null) continue;
            ret.add(newCM);
        }
        return new ClassPathManager(this.getCompiler(), ret);
    }

    public Collection getAllPossibleTypeNames() {
        ArrayList ret = new ArrayList();
        Iterator i = this.classManagers.iterator();
        while (i.hasNext()) {
            ClassManager cm = (ClassManager)i.next();
            ret.addAll(cm.getAllPossibleTypeNames());
        }
        return ret;
    }

    public Collection getPathStrings() {
        ArrayList ret = new ArrayList();
        Iterator i = this.classManagers.iterator();
        while (i.hasNext()) {
            ClassManager cm = (ClassManager)i.next();
            ret.addAll(cm.getPathStrings());
        }
        return ret;
    }
}

