/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.bytecode;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.aspectj.compiler.base.CompilerObject;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.bytecode.ASTConnection;
import org.aspectj.compiler.base.bytecode.ClassFile;
import org.aspectj.compiler.base.bytecode.InvalidClassFileException;

public abstract class ClassManager
extends CompilerObject {
    private ASTConnection astConnection = null;
    private static byte[] bytes = new byte[512000];

    public ClassManager(JavaCompiler compiler) {
        super(compiler);
    }

    private ASTConnection getASTConnection() {
        if (this.astConnection == null) {
            this.astConnection = new ASTConnection(this.getCompiler());
        }
        return this.astConnection;
    }

    public abstract TypeDec findTypeDec(String var1);

    public abstract ClassManager makeSubPackageManager(String var1);

    public abstract Collection getAllPossibleTypeNames();

    public TypeDec makeTypeDec(String name, InputStream inputStream) {
        TypeDec typeDec;
        if (inputStream == null) {
            return null;
        }
        try {
            TypeDec typeDec2;
            ClassFile classFile = new ClassFile();
            try {
                DataInputStream dataStream = new DataInputStream(this.prereadInputStream(inputStream));
                classFile.readFrom(dataStream);
            }
            catch (IOException e) {
                System.err.println("ioexception for: " + name + ", " + inputStream);
                e.printStackTrace();
                TypeDec typeDec3 = null;
                Object var8_9 = null;
                try {
                    inputStream.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                return typeDec3;
            }
            catch (InvalidClassFileException icfe) {
                System.err.println("bad class file for: " + name + ", " + inputStream);
                icfe.printStackTrace();
                TypeDec typeDec4 = null;
                Object var8_10 = null;
                try {
                    inputStream.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                return typeDec4;
            }
            if (this.getCompiler().getOptionVerbose()) {
                this.getCompiler().showMessage("loading: " + name);
            }
            typeDec = typeDec2 = this.getASTConnection().makeTypeDec(classFile);
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            try {
                inputStream.close();
            }
            catch (IOException e2) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException e2) {
            // empty catch block
        }
        return typeDec;
    }

    public Collection getPathStrings() {
        LinkedList<String> ret = new LinkedList<String>();
        ret.add(this.getPathString());
        return ret;
    }

    protected String getPathString() {
        throw new UnsupportedOperationException("no simple string");
    }

    private InputStream prereadInputStream(InputStream stream) throws IOException {
        int nread;
        int index = 0;
        while ((nread = stream.read(bytes, index, bytes.length - index)) != -1) {
            index += nread;
        }
        stream.close();
        return new ByteArrayInputStream(bytes, 0, index);
    }

    public List filenameToClassName(String filename) {
        int last = 0;
        ArrayList<String> ret = new ArrayList<String>();
        int i = 0;
        int len = filename.length();
        while (i < len) {
            char ch = filename.charAt(i);
            if (ch == '.' || ch == '/' || ch == '\\' || ch == '$') {
                ret.add(filename.substring(last, i));
                last = i + 1;
            }
            ++i;
        }
        return ret;
    }
}

