/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.bytecode;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import org.aspectj.compiler.base.bytecode.Attributes;
import org.aspectj.compiler.base.bytecode.ConstantPool;

public class ClassFile {
    ConstantPool pool;
    int modifiers;
    ConstantPool.Class thisClass;
    ConstantPool.Class superClass;
    ConstantPool.Class[] interfaces;
    FieldInfo[] fields;
    MethodInfo[] methods;
    Attributes attributes;

    public String getClassName() {
        return this.thisClass.getName();
    }

    private void assertTrue(boolean test, String message) {
        if (!test) {
            throw new RuntimeException(message);
        }
    }

    void readConstantPool(DataInputStream stream) throws IOException {
        this.pool = new ConstantPool();
        this.pool.readFrom(stream);
    }

    void readInterfaces(DataInputStream stream) throws IOException {
        int interfacesCount = stream.readUnsignedShort();
        this.interfaces = new ConstantPool.Class[interfacesCount];
        int i = 0;
        while (i < interfacesCount) {
            this.interfaces[i] = this.pool.getClass(stream.readUnsignedShort());
            ++i;
        }
    }

    void readFields(DataInputStream stream) throws IOException {
        int fieldsCount = stream.readUnsignedShort();
        this.fields = new FieldInfo[fieldsCount];
        int i = 0;
        while (i < fieldsCount) {
            this.fields[i] = new FieldInfo();
            this.fields[i].readFrom(stream);
            ++i;
        }
    }

    void readMethods(DataInputStream stream) throws IOException {
        int methodsCount = stream.readUnsignedShort();
        this.methods = new MethodInfo[methodsCount];
        int i = 0;
        while (i < methodsCount) {
            this.methods[i] = new MethodInfo();
            this.methods[i].readFrom(stream);
            ++i;
        }
    }

    void readAttributes(DataInputStream stream) throws IOException {
        this.attributes = Attributes.createFrom(this, stream);
    }

    public void readFrom(DataInputStream stream) throws IOException {
        int magic = stream.readInt();
        int minorVersion = stream.readUnsignedShort();
        int majorVersion = stream.readUnsignedShort();
        this.assertTrue(magic == -889275714, "bad magic number: " + Integer.toString(magic, 16));
        this.assertTrue(majorVersion >= 45, "bad major version: " + majorVersion);
        this.readConstantPool(stream);
        this.modifiers = stream.readUnsignedShort();
        this.thisClass = this.pool.getClass(stream.readUnsignedShort());
        this.superClass = this.pool.getClass(stream.readUnsignedShort());
        this.readInterfaces(stream);
        this.readFields(stream);
        this.readMethods(stream);
        this.readAttributes(stream);
    }

    void print() {
        System.err.println("modifiers: " + Modifier.toString(this.modifiers));
        System.err.println("this: " + this.thisClass);
        System.err.println("extends: " + this.superClass);
        System.err.println("interfaces");
        ClassFile.printObjects(this.interfaces);
        System.err.println("fields");
        ClassFile.printObjects(this.fields);
        System.err.println("methods");
        ClassFile.printObjects(this.methods);
        System.err.println("attributes: " + this.attributes);
    }

    static void printObjects(Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            System.err.println("" + i + ": " + objects[i]);
            ++i;
        }
    }

    public static void main(String[] args) throws Exception {
        ClassFile cf = new ClassFile();
        cf.readFrom(new DataInputStream(new FileInputStream(args[0])));
        cf.print();
        int i = 0;
        while (i < cf.pool.constants.length) {
            System.err.println(cf.pool.constants[i]);
            ++i;
        }
    }

    class MethodInfo
    extends MemberInfo {
        MethodInfo() {
        }
    }

    class FieldInfo
    extends MemberInfo {
        FieldInfo() {
        }
    }

    class MemberInfo {
        int modifiers;
        ConstantPool.UTF name;
        ConstantPool.UTF descriptor;
        Attributes attributes;
        static /* synthetic */ Class class$org$aspectj$compiler$base$bytecode$Attributes$ExceptionsAttribute;
        static /* synthetic */ Class class$org$aspectj$compiler$base$bytecode$Attributes$DeprecatedAttribute;

        MemberInfo() {
        }

        void readFrom(DataInputStream stream) throws IOException {
            this.modifiers = stream.readUnsignedShort();
            this.name = ClassFile.this.pool.getUTF(stream.readUnsignedShort());
            this.descriptor = ClassFile.this.pool.getUTF(stream.readUnsignedShort());
            this.attributes = Attributes.createFrom(ClassFile.this, stream);
        }

        public ConstantPool.Class[] getExceptions() {
            Attributes.ExceptionsAttribute excs = (Attributes.ExceptionsAttribute)this.attributes.findAttribute(class$org$aspectj$compiler$base$bytecode$Attributes$ExceptionsAttribute == null ? (class$org$aspectj$compiler$base$bytecode$Attributes$ExceptionsAttribute = MemberInfo.class$("org.aspectj.compiler.base.bytecode.Attributes$ExceptionsAttribute")) : class$org$aspectj$compiler$base$bytecode$Attributes$ExceptionsAttribute);
            if (excs == null) {
                return null;
            }
            return excs.exceptions;
        }

        public boolean isDeprecated() {
            return this.attributes.findAttribute(class$org$aspectj$compiler$base$bytecode$Attributes$DeprecatedAttribute == null ? (class$org$aspectj$compiler$base$bytecode$Attributes$DeprecatedAttribute = MemberInfo.class$("org.aspectj.compiler.base.bytecode.Attributes$DeprecatedAttribute")) : class$org$aspectj$compiler$base$bytecode$Attributes$DeprecatedAttribute) != null;
        }

        public String toString() {
            return Modifier.toString(this.modifiers) + " " + this.name.value + " " + this.descriptor.value + ": " + this.attributes;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

