/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.bcg.pool;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.compiler.base.bcg.pool.Constant;
import org.aspectj.compiler.base.bcg.pool.ConstantPool;

public class LongConstant
extends Constant {
    long value;

    LongConstant() {
    }

    LongConstant(long value) {
        this.value = value;
    }

    void writeTo(DataOutputStream stream) throws IOException {
        stream.writeByte(5);
        stream.writeLong(this.value);
    }

    boolean isBig() {
        return true;
    }

    public String toString() {
        return Constant.rep(this.getIndex(), "(long " + this.value + ")");
    }

    public boolean equals(Object other) {
        if (!(other instanceof LongConstant)) {
            return false;
        }
        LongConstant o = (LongConstant)other;
        return this.value == o.value;
    }

    public int hashCode() {
        return (int)(this.value * 5L);
    }

    void readFrom(DataInputStream stream, ConstantPool pool) throws IOException {
        this.value = stream.readLong();
    }
}

