/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.bcg.pool;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.compiler.base.bcg.pool.Constant;
import org.aspectj.compiler.base.bcg.pool.ConstantPool;

public class DoubleConstant
extends Constant {
    double value;

    DoubleConstant() {
    }

    DoubleConstant(double value) {
        this.value = value;
    }

    void writeTo(DataOutputStream stream) throws IOException {
        stream.writeByte(6);
        stream.writeDouble(this.value);
    }

    boolean isBig() {
        return true;
    }

    public String toString() {
        return Constant.rep(this.getIndex(), "(double " + this.value + ")");
    }

    public boolean equals(Object other) {
        if (!(other instanceof DoubleConstant)) {
            return false;
        }
        DoubleConstant o = (DoubleConstant)other;
        return this.value == o.value;
    }

    public int hashCode() {
        return (int)(this.value * 7.0);
    }

    void readFrom(DataInputStream stream, ConstantPool pool) throws IOException {
        this.value = stream.readDouble();
    }
}

