/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.bcg.pool;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aspectj.compiler.base.ast.ArrayType;
import org.aspectj.compiler.base.ast.NameType;
import org.aspectj.compiler.base.ast.RefType;
import org.aspectj.compiler.base.bcg.Asserts;
import org.aspectj.compiler.base.bcg.ClassfileBuilder;
import org.aspectj.compiler.base.bcg.pool.ClassConstant;
import org.aspectj.compiler.base.bcg.pool.Constant;
import org.aspectj.compiler.base.bcg.pool.DoubleConstant;
import org.aspectj.compiler.base.bcg.pool.FieldrefConstant;
import org.aspectj.compiler.base.bcg.pool.FloatConstant;
import org.aspectj.compiler.base.bcg.pool.IntConstant;
import org.aspectj.compiler.base.bcg.pool.InterfaceMethodrefConstant;
import org.aspectj.compiler.base.bcg.pool.LongConstant;
import org.aspectj.compiler.base.bcg.pool.MethodrefConstant;
import org.aspectj.compiler.base.bcg.pool.NameAndTypeConstant;
import org.aspectj.compiler.base.bcg.pool.Placeholder;
import org.aspectj.compiler.base.bcg.pool.StringConstant;
import org.aspectj.compiler.base.bcg.pool.Utf8Constant;

public final class ConstantPool {
    private boolean isResolvedFlag = false;
    private ClassfileBuilder cfb;
    private List table = new ArrayList();
    private Map cache;

    public boolean isResolved() {
        return this.isResolvedFlag;
    }

    public ConstantPool(ClassfileBuilder cfb) {
        this.table.add(Placeholder.it);
        this.cache = new Hashtable();
        this.cfb = cfb;
    }

    public void resolve() {
        if (this.isResolved()) {
            throw new RuntimeException("already resolved");
        }
        Object[] a = this.table.toArray();
        this.table.clear();
        Arrays.sort(a);
        this.table.add(Placeholder.it);
        int i = 0;
        int len = a.length;
        while (i < len) {
            this.add1((Constant)a[i]);
            ++i;
        }
        this.isResolvedFlag = true;
    }

    public Constant get(int i) {
        return (Constant)this.table.get(i);
    }

    Constant get(int i, Constant young) {
        Constant c = (Constant)this.table.get(i);
        if (c instanceof Placeholder) {
            this.table.set(i, young);
            young.setIndex(i);
            return young;
        }
        return c;
    }

    private Constant add(Constant constant) {
        Constant cachedConstant = (Constant)this.cache.get(constant);
        if (cachedConstant != null) {
            return cachedConstant;
        }
        this.add1(constant);
        return constant;
    }

    private void add1(Constant constant) {
        if (constant instanceof Placeholder) {
            return;
        }
        Asserts.assertUU2(this.table.size(), "Too many constants in constant pool");
        constant.setIndex(this.table.size());
        this.cache.put(constant, constant);
        this.table.add(constant);
        if (constant.isBig()) {
            this.table.add(Placeholder.it);
        }
    }

    public static void writeIndex(Constant constant, DataOutputStream stream) throws IOException {
        if (constant == null) {
            stream.writeShort(0);
        } else {
            constant.writeIndex(stream);
        }
    }

    public void writeTo(DataOutputStream stream) throws IOException {
        if (!this.isResolved()) {
            throw new RuntimeException("must resolve constant pool first");
        }
        stream.writeShort((short)this.table.size());
        Iterator i = this.table.iterator();
        while (i.hasNext()) {
            Constant c = (Constant)i.next();
            c.writeTo(stream);
        }
    }

    public void display(int indent, boolean inline) {
        System.err.print("(pool");
        ConstantPool.display(this.table, indent + 2, inline);
        System.err.print(")");
    }

    public static void display(List l, int indent, boolean inline) {
        Iterator i = l.iterator();
        while (i.hasNext()) {
            Constant c = (Constant)i.next();
            if (c instanceof Placeholder) continue;
            ConstantPool.between(indent, inline);
            c.display(indent, inline);
        }
    }

    static void between(int indent, boolean inline) {
        if (inline) {
            System.err.print(" ");
        } else {
            System.err.println();
            int s = indent;
            while (s >= 0) {
                System.err.print(" ");
                --s;
            }
        }
    }

    public ClassConstant addClass(RefType refType) {
        if (refType instanceof ArrayType) {
            return this.addClass((ArrayType)refType);
        }
        return this.addClass((NameType)refType);
    }

    public ClassConstant addClass(ArrayType arrayType) {
        return this.addClassNoInnerCheck(arrayType);
    }

    public ClassConstant addClass(NameType nameType) {
        if (!nameType.isPackageMember()) {
            this.cfb.addInnerClassRef(nameType);
        }
        return this.addClassNoInnerCheck(nameType);
    }

    public ClassConstant addClassNoInnerCheck(RefType refType) {
        return (ClassConstant)this.add(new ClassConstant(this.addUtf8(refType.getInternalName())));
    }

    public Utf8Constant addUtf8(String name) {
        return (Utf8Constant)this.add(new Utf8Constant(name));
    }

    public StringConstant addString(String value) {
        return (StringConstant)this.add(new StringConstant(this.addUtf8(value)));
    }

    public IntConstant addInt(int value) {
        return (IntConstant)this.add(new IntConstant(value));
    }

    public FloatConstant addFloat(float value) {
        return (FloatConstant)this.add(new FloatConstant(value));
    }

    public LongConstant addLong(long value) {
        return (LongConstant)this.add(new LongConstant(value));
    }

    public DoubleConstant addDouble(double value) {
        return (DoubleConstant)this.add(new DoubleConstant(value));
    }

    public MethodrefConstant addMethodRef(NameType nameType, String name, String descriptor) {
        return (MethodrefConstant)this.add(new MethodrefConstant(this.addClass(nameType), this.addNameAndType(name, descriptor)));
    }

    public InterfaceMethodrefConstant addInterfaceMethodRef(NameType nameType, String name, String descriptor) {
        return (InterfaceMethodrefConstant)this.add(new InterfaceMethodrefConstant(this.addClass(nameType), this.addNameAndType(name, descriptor)));
    }

    public FieldrefConstant addFieldRef(NameType nameType, String name, String descriptor) {
        return (FieldrefConstant)this.add(new FieldrefConstant(this.addClass(nameType), this.addNameAndType(name, descriptor)));
    }

    public NameAndTypeConstant addNameAndType(String name, String descriptor) {
        return (NameAndTypeConstant)this.add(new NameAndTypeConstant(this.addUtf8(name), this.addUtf8(descriptor)));
    }

    public void readFrom(DataInputStream stream) throws IOException {
        int size = stream.readUnsignedShort();
        this.table.clear();
        int i = size - 1;
        while (i >= 0) {
            this.table.add(Placeholder.it);
            --i;
        }
        int i2 = 1;
        while (i2 < size) {
            Constant c;
            int tag = stream.readUnsignedByte();
            switch (tag) {
                case 1: {
                    c = this.get(i2, new Utf8Constant());
                    break;
                }
                case 3: {
                    c = this.get(i2, new IntConstant());
                    break;
                }
                case 4: {
                    c = this.get(i2, new FloatConstant());
                    break;
                }
                case 5: {
                    c = this.get(i2, new LongConstant());
                    ++i2;
                    break;
                }
                case 6: {
                    c = this.get(i2, new DoubleConstant());
                    ++i2;
                    break;
                }
                case 7: {
                    c = this.get(i2, new ClassConstant());
                    break;
                }
                case 8: {
                    c = this.get(i2, new StringConstant());
                    break;
                }
                case 9: {
                    c = this.get(i2, new FieldrefConstant());
                    break;
                }
                case 10: {
                    c = this.get(i2, new MethodrefConstant());
                    break;
                }
                case 11: {
                    c = this.get(i2, new InterfaceMethodrefConstant());
                    break;
                }
                case 12: {
                    c = this.get(i2, new NameAndTypeConstant());
                    break;
                }
                default: {
                    throw new RuntimeException("unknown constant pool tag " + tag);
                }
            }
            c.readFrom(stream, this);
            ++i2;
        }
        Iterator i3 = this.table.iterator();
        while (i3.hasNext()) {
            Object o = i3.next();
            if (o instanceof Placeholder) continue;
            this.cache.put(o, o);
        }
    }
}

