/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.LiteralExpr;
import org.aspectj.compiler.base.ast.PrimitiveType;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.base.bcg.Label;

public final class VoidType
extends PrimitiveType {
    public String getName() {
        return "void";
    }

    public int getTypeIndex() {
        return 1;
    }

    public Type getRefType() {
        return this.getTypeManager().getType("java.lang", "Void");
    }

    public Expr getNullExpr() {
        return this.getAST().makeNull();
    }

    public Expr makeObject(Expr expr) {
        return this.getAST().makeCast(this.getTypeManager().getObjectType(), this.getAST().makeNull());
    }

    public Expr fromObject(Expr expr) {
        return this.getAST().makeStaticCall(this.getTypeManager().getConversionsType(), "voidValue", expr);
    }

    public VoidType(JavaCompiler compiler) {
        super(compiler);
    }

    final LiteralExpr foldCast(LiteralExpr lit) {
        return this.unsupportedFold();
    }

    final LiteralExpr foldPlusOp(LiteralExpr rand) {
        return this.unsupportedFold();
    }

    final LiteralExpr foldMinusOp(LiteralExpr rand) {
        return this.unsupportedFold();
    }

    final LiteralExpr foldBitNotOp(LiteralExpr rand) {
        return this.unsupportedFold();
    }

    final LiteralExpr foldLogNotOp(LiteralExpr rand) {
        return this.unsupportedFold();
    }

    final LiteralExpr foldAddOp(LiteralExpr lit1, LiteralExpr lit2) {
        return this.unsupportedFold();
    }

    final LiteralExpr foldNumericOp(String op, LiteralExpr lit1, LiteralExpr lit2) {
        return this.unsupportedFold();
    }

    final LiteralExpr foldBitwiseOp(String op, LiteralExpr lit1, LiteralExpr lit2) {
        return this.unsupportedFold();
    }

    final LiteralExpr foldShiftOp(String op, LiteralExpr lit1, LiteralExpr lit2) {
        return this.unsupportedFold();
    }

    final LiteralExpr foldEqualityTestOp(String op, LiteralExpr lit1, LiteralExpr lit2) {
        return this.unsupportedFold();
    }

    final LiteralExpr foldNumericTestOp(String op, LiteralExpr lit1, LiteralExpr lit2) {
        return this.unsupportedFold();
    }

    public String getDescriptor() {
        return "V";
    }

    public int getSlotCount() {
        return 0;
    }

    public final void emitLoad(CodeBuilder cb, int loc) {
    }

    public final void emitStore(CodeBuilder cb, int loc) {
    }

    public final void emitReturn(CodeBuilder cb) {
        cb.emitRETURN();
    }

    final void emitPop(CodeBuilder cb) {
    }

    final void emitDup(CodeBuilder cb) {
    }

    final void emitDupX1(CodeBuilder cb) {
    }

    final void emitDupX2(CodeBuilder cb) {
    }

    final void emitZero(CodeBuilder cb) {
        this.unsupportedEmit();
    }

    final void emitOne(CodeBuilder cb) {
        this.unsupportedEmit();
    }

    final void emitMinusOne(CodeBuilder cb) {
        this.unsupportedEmit();
    }

    final void emitBitNot(CodeBuilder cb) {
        this.unsupportedEmit();
    }

    final void emitLogNot(CodeBuilder cb) {
        this.unsupportedEmit();
    }

    final void emitNeg(CodeBuilder cb) {
        this.unsupportedEmit();
    }

    final void emitAdd(CodeBuilder cb) {
        this.unsupportedEmit();
    }

    final void emitAload(CodeBuilder cb) {
        this.unsupportedEmit();
    }

    final void emitAstore(CodeBuilder cb) {
        this.unsupportedEmit();
    }

    final void emitNumericOp(CodeBuilder cb, String op) {
        this.unsupportedEmit();
    }

    final void emitBitwiseOp(CodeBuilder cb, String op) {
        this.unsupportedEmit();
    }

    final void emitShiftOp(CodeBuilder cb, String op) {
        this.unsupportedEmit();
    }

    final void emitCast(CodeBuilder cb, Type castTo) {
        this.unsupportedEmit();
    }

    final void emitEqualityCompare(CodeBuilder cb, String op, Label t, Label f) {
        this.unsupportedEmit();
    }

    final void emitNumericCompare(CodeBuilder cb, String op, Label t, Label f) {
        this.unsupportedEmit();
    }
}

