/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.ASTFixerPass;
import org.aspectj.compiler.base.ByteCodeCleanupPass;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.FrameLocPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.EmptyStmt;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Stmt;
import org.aspectj.compiler.base.ast.TryCatchStmt;
import org.aspectj.compiler.base.ast.TryStmt;
import org.aspectj.compiler.base.ast.WindingStmt;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.base.bcg.Label;

public class TryFinallyStmt
extends TryStmt
implements WindingStmt {
    private int retValLoc;
    private int retPtrLoc;
    protected Stmt body;
    protected Stmt _finally;

    public void checkSpec() {
        super.checkSpec();
        if (this._finally == null) {
            this.showError("'try' without 'catch' or 'finally'");
        }
        if (!this.includesDesugaredCatch()) {
            this.body.requireBlockStmt();
        }
        this._finally.requireBlockStmt();
    }

    private boolean includesDesugaredCatch() {
        return this.body instanceof TryCatchStmt && this.body.isSynthetic();
    }

    public void unparse(CodeWriter writer) {
        if (this.includesDesugaredCatch()) {
            TryCatchStmt tcb = (TryCatchStmt)this.body;
            writer.writeKeyword("try");
            writer.optionalSpace();
            writer.write(tcb.getBody());
            writer.writeChildren(tcb.getCatches());
            writer.writeKeyword("finally");
            writer.optionalSpace();
            writer.write(this._finally);
        } else {
            writer.writeKeyword("try");
            writer.optionalSpace();
            writer.write(this.body);
            writer.writeKeyword("finally");
            writer.optionalSpace();
            writer.write(this._finally);
        }
    }

    public ASTObject postFixAST(ASTFixerPass fixer) {
        if (!this.isOptional()) {
            return super.postFixAST(fixer);
        }
        this.setIsOptional(false);
        return this;
    }

    public void walkFlow(FlowCheckerPass w) {
        FlowCheckerPass.Vars beforeV = w.getVars();
        FlowCheckerPass.ESet beforeExns = w.popExns();
        w.enterContext(this);
        w.process(this.getBody());
        w.leaveContext();
        boolean bodyLive = w.isLive();
        FlowCheckerPass.ESet bodyExns = w.popExns();
        FlowCheckerPass.Vars cvExit = w.getVars();
        FlowCheckerPass.Vars fv = FlowCheckerPass.Vars.makeSets(beforeV.getDa(), cvExit.getDua());
        w.setLive(true);
        w.setVars(fv);
        w.process(this.getFinally());
        if (w.isLive()) {
            w.releasePendingTransfers(this);
            w.setExns(bodyExns.union(w.getExns()).union(beforeExns));
        } else if (!this.getOptions().strict) {
            w.setExns(bodyExns.union(w.getExns()).union(beforeExns));
        } else {
            w.setExns(w.getExns().union(beforeExns));
        }
        boolean liveSoFar = bodyLive & w.isLive();
        w.setVars(FlowCheckerPass.Vars.makeSets(cvExit.getDa().union(w.getVars().getDa()), w.getVars().getDua()));
        w.setLive(liveSoFar);
    }

    public void walkCleanup(ByteCodeCleanupPass w) {
        w.enterContext(this);
        this.setBody((Stmt)w.process(this.getBody()));
        w.leaveContext();
        boolean bodyLive = w.isLive();
        w.setLive(true);
        this.setFinally((Stmt)w.process(this.getFinally()));
        boolean liveSoFar = bodyLive & w.isLive();
        w.setLive(liveSoFar);
    }

    public ASTObject postCleanup(ByteCodeCleanupPass walker) {
        if (this.getBody() instanceof EmptyStmt) {
            return this.getFinally();
        }
        return this;
    }

    protected void cgStmt(CodeBuilder cb) {
        Label startBody = cb.genAnchor();
        Label endBody = cb.genAnchor();
        Label startExn = cb.genAnchor();
        Label startFinally = cb.genAnchor();
        Label end = cb.genLabel();
        cb.emitLabel(startBody);
        cb.enterWindingContext(this, startFinally);
        this.getBody().cgTop(cb);
        cb.leaveContext();
        cb.emitLabel(endBody);
        if (this.body.completesNormally()) {
            cb.emitJSR(startFinally);
            if (this.getFinally().completesNormally()) {
                cb.emitJump(end);
            }
        }
        cb.emitLabel(startExn);
        cb.pushStack(1);
        cb.emitASTORE(this.retValLoc);
        cb.emitJSR(startFinally);
        cb.emitALOAD(this.retValLoc);
        cb.emitATHROW();
        cb.emitLabel(startFinally);
        cb.pushStack(1);
        cb.emitASTORE(this.retPtrLoc);
        this.getFinally().cgTop(cb);
        if (this.getFinally().completesNormally()) {
            cb.emitRET(this.retPtrLoc);
        }
        cb.addHandler(startBody, endBody, startExn, null);
        cb.emitLabel(end);
    }

    public int getRetValLoc() {
        return this.retValLoc;
    }

    public void walkFrameLoc(FrameLocPass walker) {
        boolean inTryFinally = walker.inTryFinally;
        walker.inTryFinally = true;
        int start = walker.getfs();
        walker.process(this.getBody());
        this.retValLoc = walker.allocate(2);
        this.retPtrLoc = walker.allocate(1);
        walker.process(this.getFinally());
        walker.inTryFinally = inTryFinally;
        walker.setfs(start);
    }

    public Stmt getBody() {
        return this.body;
    }

    public void setBody(Stmt _body) {
        if (_body != null) {
            _body.setParent(this);
        }
        this.body = _body;
    }

    public Stmt getFinally() {
        return this._finally;
    }

    public void setFinally(Stmt __finally) {
        if (__finally != null) {
            __finally.setParent(this);
        }
        this._finally = __finally;
    }

    public TryFinallyStmt(SourceLocation location, Stmt _body, Stmt __finally) {
        super(location);
        this.setBody(_body);
        this.setFinally(__finally);
    }

    protected TryFinallyStmt(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        TryFinallyStmt ret = new TryFinallyStmt(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.body != null) {
            ret.setBody((Stmt)walker.process(this.body));
        }
        if (this._finally != null) {
            ret.setFinally((Stmt)walker.process(this._finally));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.body;
            }
            case 1: {
                return this._finally;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "body";
            }
            case 1: {
                return "finally";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setBody((Stmt)child);
                return;
            }
            case 1: {
                this.setFinally((Stmt)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 2;
    }

    public String getDefaultDisplayName() {
        return "TryFinallyStmt()";
    }
}

