/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.AssignmentCheckerPass;
import org.aspectj.compiler.base.ByteCodeCleanupPass;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.AssignExpr;
import org.aspectj.compiler.base.ast.ByteType;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.IntLiteralExpr;
import org.aspectj.compiler.base.ast.IntType;
import org.aspectj.compiler.base.ast.LiteralExpr;
import org.aspectj.compiler.base.ast.ShortType;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.base.bcg.Label;

public class TriTestExpr
extends Expr {
    protected Expr test;
    protected Expr _true;
    protected Expr _false;

    public Type discoverType() {
        Type falseTy;
        Type testTy = this.getTest().getType();
        if (testTy != this.getTypeManager().booleanType) {
            this.showError("Incompatable type for ?: Can't convert " + testTy.getString() + " to boolean");
        }
        Expr trueExpr = this.getTrue();
        Expr falseExpr = this.getFalse();
        Type trueTy = trueExpr.getType();
        if (trueTy == (falseTy = falseExpr.getType())) {
            return trueTy;
        }
        if (trueTy.isNumeric() && falseTy.isNumeric()) {
            if (trueTy instanceof ShortType && falseTy instanceof ByteType || trueTy instanceof ByteType && falseTy instanceof ShortType) {
                return this.getTypeManager().shortType;
            }
            if (trueExpr instanceof IntLiteralExpr && trueTy instanceof IntType && trueExpr.isAssignableTo(falseTy)) {
                return falseTy;
            }
            if (falseExpr instanceof IntLiteralExpr && falseTy instanceof IntType && falseExpr.isAssignableTo(trueTy)) {
                return trueTy;
            }
            return this.getTypeManager().binaryNumericPromotion(trueTy, falseTy);
        }
        if (trueTy.isReferenceType() && falseTy.isReferenceType()) {
            if (trueTy.isAssignableFrom(falseTy)) {
                return trueTy;
            }
            if (falseTy.isAssignableFrom(trueTy)) {
                return falseTy;
            }
            this.showError("Incompatable type for ?: Can't convert between " + trueTy.getString() + " and " + falseTy.getString());
            return trueTy;
        }
        this.showError("Incompatable type for ?: Can't convert between " + trueTy.getString() + " and " + falseTy.getString());
        return trueTy;
    }

    public void checkSpec() {
        if (this._false instanceof AssignExpr) {
            this._false.showError("assignment expression not allowed here");
        }
    }

    public void preAssignmentCheck(AssignmentCheckerPass walker) {
        this.getType();
    }

    public ASTObject postAssignmentCheck(AssignmentCheckerPass walker) {
        this.setType(null);
        if (this.getTrue() instanceof LiteralExpr && this.getFalse() instanceof LiteralExpr) {
            if (this.getTest().isConstantTrue()) {
                return this.getTrue();
            }
            if (this.getTest().isConstantFalse()) {
                return this.getFalse();
            }
        }
        return this;
    }

    public void unparse(CodeWriter writer) {
        writer.write(this.test);
        writer.writeOp("?");
        writer.write(this._true);
        writer.writeOp(":");
        writer.write(this._false);
    }

    public void walkFlow(FlowCheckerPass w) {
        w.processBoolean(this.getTest());
        FlowCheckerPass.Vars p0 = w.getVars();
        if (this.getType().isBoolean()) {
            w.setVars(p0.getTrue());
            w.processBoolean(this.getTrue());
            FlowCheckerPass.Vars p1 = w.getVars();
            w.setVars(p0.getFalse());
            w.processBoolean(this.getFalse());
            FlowCheckerPass.Vars p2 = w.getVars();
            w.setVars(p1.getTrue().join(p2.getTrue()), p1.getFalse().join(p2.getFalse()));
        } else {
            w.setVars(p0.getTrue());
            w.process(this.getTrue());
            FlowCheckerPass.Vars t1 = w.getVars();
            w.setVars(p0.getFalse());
            w.process(this.getFalse());
            FlowCheckerPass.Vars t2 = w.getVars();
            w.setVars(t1.join(t2));
        }
    }

    public void normalizeFlow(FlowCheckerPass w) {
    }

    public ASTObject postCleanup(ByteCodeCleanupPass w) {
        if (this.getTest().isConstantTrue()) {
            return this.getTrue();
        }
        if (this.getTest().isConstantFalse()) {
            return this.getFalse();
        }
        return this;
    }

    protected void cgValue(CodeBuilder cb) {
        Type ty = this.getType();
        Label trueLab = cb.genLabel();
        Label falseLab = cb.genLabel();
        Label endLab = cb.genLabel();
        this.test.cgTest(cb, trueLab, falseLab);
        cb.emitLabel(trueLab);
        this._true.cgValue(cb, ty);
        cb.emitJump(endLab);
        cb.emitLabel(falseLab);
        cb.popStack(ty.getSlotCount());
        this._false.cgValue(cb, ty);
        cb.emitLabel(endLab);
    }

    protected void cgEffect(CodeBuilder cb) {
        Label trueLab = cb.genLabel();
        Label falseLab = cb.genLabel();
        Label endLab = cb.genLabel();
        this.test.cgTest(cb, trueLab, falseLab);
        cb.emitLabel(trueLab);
        this._true.cgEffect(cb);
        cb.emitJump(endLab);
        cb.emitLabel(falseLab);
        this._false.cgEffect(cb);
        cb.emitLabel(endLab);
    }

    protected void cgTest(CodeBuilder cb, Label tdest, Label fdest) {
        Label trueLab = cb.genLabel();
        Label falseLab = cb.genLabel();
        this.test.cgTest(cb, trueLab, falseLab);
        cb.emitLabel(trueLab);
        this._true.cgTest(cb, tdest, fdest);
        cb.emitLabel(falseLab);
        this._false.cgTest(cb, tdest, fdest);
    }

    public Expr getTest() {
        return this.test;
    }

    public void setTest(Expr _test) {
        if (_test != null) {
            _test.setParent(this);
        }
        this.test = _test;
    }

    public Expr getTrue() {
        return this._true;
    }

    public void setTrue(Expr __true) {
        if (__true != null) {
            __true.setParent(this);
        }
        this._true = __true;
    }

    public Expr getFalse() {
        return this._false;
    }

    public void setFalse(Expr __false) {
        if (__false != null) {
            __false.setParent(this);
        }
        this._false = __false;
    }

    public TriTestExpr(SourceLocation location, Expr _test, Expr __true, Expr __false) {
        super(location);
        this.setTest(_test);
        this.setTrue(__true);
        this.setFalse(__false);
    }

    protected TriTestExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        TriTestExpr ret = new TriTestExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.test != null) {
            ret.setTest((Expr)walker.process(this.test));
        }
        if (this._true != null) {
            ret.setTrue((Expr)walker.process(this._true));
        }
        if (this._false != null) {
            ret.setFalse((Expr)walker.process(this._false));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.test;
            }
            case 1: {
                return this._true;
            }
            case 2: {
                return this._false;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "test";
            }
            case 1: {
                return "true";
            }
            case 2: {
                return "false";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setTest((Expr)child);
                return;
            }
            case 1: {
                this.setTrue((Expr)child);
                return;
            }
            case 2: {
                this.setFalse((Expr)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 3;
    }

    public String getDefaultDisplayName() {
        return "TriTestExpr()";
    }
}

