/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import java.io.File;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.Comment;
import org.aspectj.compiler.base.ast.CompilationUnit;
import org.aspectj.compiler.base.ast.FormalComment;
import org.aspectj.compiler.base.ast.SourceLocation;

public class TextSourceLocation
extends SourceLocation {
    protected int startPosition = -1;
    protected int endPosition = -1;
    protected CompilationUnit compilationUnit;
    protected Comment comment;

    public String toString() {
        return "TextSourceLocation(" + this.getSourceFileName() + ":" + this.getBeginLine() + ":" + this.getBeginColumn() + ")";
    }

    public TextSourceLocation(CompilationUnit compilationUnit, int start, int end) {
        this.compilationUnit = compilationUnit;
        this.startPosition = start;
        this.endPosition = end;
    }

    public JavaCompiler getCompiler() {
        return this.getCompilationUnit().getCompiler();
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public int getEndPosition() {
        return this.endPosition;
    }

    public int getBeginLine() {
        if (this.startPosition == -1) {
            return -1;
        }
        return this.getCompilationUnit().getLine(this.startPosition);
    }

    public int getEndLine() {
        if (this.endPosition == -1) {
            return -1;
        }
        return this.getCompilationUnit().getLine(this.endPosition);
    }

    public int getBeginColumn() {
        if (this.startPosition == -1) {
            return -1;
        }
        return this.getCompilationUnit().getColumn(this.startPosition);
    }

    public int getEndColumn() {
        if (this.endPosition == -1) {
            return -1;
        }
        return this.getCompilationUnit().getColumn(this.endPosition);
    }

    public Comment getComment() {
        return this.comment;
    }

    public void addComment(Comment _comment) {
        if (this.comment == null) {
            this.comment = _comment;
        } else {
            this.comment.addComment(_comment);
        }
    }

    public void clearComment() {
        this.comment = null;
    }

    public void setFormalComment(String comment) {
        this.addComment(new FormalComment(comment));
    }

    public String getFormalComment() {
        if (this.comment == null) {
            return "";
        }
        return this.comment.getFormalComment();
    }

    public CompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public File getSourceFile() {
        return this.getCompilationUnit().getSourceFile();
    }

    public String getSourceFileName() {
        return this.getCompilationUnit().getSourceCanonicalPath();
    }

    public String getSourceDirectoryName() {
        return this.getCompilationUnit().getSourceDirectory();
    }

    public boolean isSynthetic() {
        return false;
    }

    public boolean hasSource() {
        return this.getCompilationUnit().getSourceFile() != null;
    }

    public boolean fromSource() {
        return this.hasSource() && this.getCompilationUnit().getDecs() != null;
    }
}

