/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.AssignExpr;
import org.aspectj.compiler.base.ast.AssignableExpr;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.IntegralType;
import org.aspectj.compiler.base.ast.IntishType;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public class ShiftAssignExpr
extends AssignExpr {
    public Type discoverType() {
        Type ty1 = this.lhs.getType();
        Type ty2 = this.rhs.getType();
        if (!(ty1 instanceof IntegralType) || !(ty2 instanceof IntegralType)) {
            this.showOperatorTypeError(this.op, ty1, ty2);
        }
        return ty1;
    }

    protected void cgValue(CodeBuilder cb) {
        this.cgValueEffect(cb, true);
    }

    protected void cgEffect(CodeBuilder cb) {
        this.cgValueEffect(cb, false);
    }

    private void cgValueEffect(CodeBuilder cb, boolean needsValue) {
        AssignableExpr lhs = this.getLhs();
        Expr rhs = this.getRhs();
        String op = this.getOp();
        Type lhsTy = lhs.getType();
        lhs.cgLvalue(cb);
        lhs.cgDupLvalue(cb);
        lhs.cgLtoRvalue(cb);
        rhs.cgValue(cb, this.getTypeManager().intType);
        lhsTy.emitShiftOp(cb, op);
        if (lhsTy instanceof IntishType) {
            ((IntishType)lhsTy).emitCastFromInt(cb);
        }
        if (needsValue) {
            lhs.cgDupRvalue(cb);
        }
        lhs.cgAssignment(cb);
    }

    public ShiftAssignExpr(SourceLocation location, AssignableExpr _lhs, String _op, Expr _rhs) {
        super(location, _lhs, _op, _rhs);
    }

    protected ShiftAssignExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        ShiftAssignExpr ret = new ShiftAssignExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.lhs != null) {
            ret.setLhs((AssignableExpr)walker.process(this.lhs));
        }
        ret.op = this.op;
        if (this.rhs != null) {
            ret.setRhs((Expr)walker.process(this.rhs));
        }
        return ret;
    }

    public String getDefaultDisplayName() {
        return "ShiftAssignExpr(op: " + this.op + ")";
    }
}

