/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import java.io.IOException;
import org.aspectj.compiler.base.AssignmentCheckerPass;
import org.aspectj.compiler.base.ByteCodeCleanupPass;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CodeDec;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.InitializerDec;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Stmt;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.VoidType;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public class ReturnStmt
extends Stmt {
    protected Expr expr;

    public void checkSpec() {
        CodeDec codeDec = this.getEnclosingCodeDec();
        if (codeDec instanceof InitializerDec) {
            this.showError("A return statement may not appear in an initializer block");
            return;
        }
        Type resultTy = codeDec.getResultType();
        Expr expr = this.getExpr();
        if (expr == null) {
            if (!resultTy.isEquivalent(this.getTypeManager().voidType)) {
                this.showError("missing return value");
            }
        } else if (resultTy instanceof VoidType) {
            this.showError("cannot return a value from method whose result type is void");
        }
    }

    public void walkFlow(FlowCheckerPass w) {
        if (this.getExpr() != null) {
            w.process(this.getExpr());
        }
        w.doReturn();
        w.setLive(false);
        w.setVars(FlowCheckerPass.getAllVars());
    }

    public void walkCleanup(ByteCodeCleanupPass w) {
        w.setLive(false);
    }

    public ASTObject postAssignmentCheck(AssignmentCheckerPass walker) {
        Expr expr = this.getExpr();
        if (expr == null) {
            return this;
        }
        CodeDec codeDec = this.getEnclosingCodeDec();
        Type resultTy = codeDec.getResultType();
        if (!expr.isAssignableTo(resultTy)) {
            expr.showTypeError(expr.getType(), resultTy);
        } else if (resultTy.isPrimitive() && resultTy != expr.getType()) {
            this.setExpr((Expr)this.getAST().forceCast(resultTy, expr).setSource(this));
        } else {
            this.setExpr((Expr)this.getAST().makeCast(resultTy, expr).setSource(this));
        }
        return this;
    }

    public void unparse(CodeWriter writer) throws IOException {
        writer.writeKeyword("return");
        if (this.expr != null) {
            writer.requiredSpace();
            writer.write(this.expr);
        }
        writer.closeStmt();
    }

    protected void cgStmt(CodeBuilder cb) {
        if (this.expr != null) {
            this.expr.cgValue(cb);
            cb.doReturn(this.expr.getType());
        } else {
            cb.doReturn(this.getTypeManager().voidType);
        }
    }

    public Expr getExpr() {
        return this.expr;
    }

    public void setExpr(Expr _expr) {
        if (_expr != null) {
            _expr.setParent(this);
        }
        this.expr = _expr;
    }

    public ReturnStmt(SourceLocation location, Expr _expr) {
        super(location);
        this.setExpr(_expr);
    }

    protected ReturnStmt(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        ReturnStmt ret = new ReturnStmt(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.expr != null) {
            ret.setExpr((Expr)walker.process(this.expr));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.expr;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "expr";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setExpr((Expr)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 1;
    }

    public String getDefaultDisplayName() {
        return "ReturnStmt()";
    }
}

