/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.AssignmentCheckerPass;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.LiteralExpr;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.base.bcg.Label;

public class ParenExpr
extends Expr {
    protected Expr expr;

    protected void bindNamesSelf() {
    }

    protected Type discoverType() {
        return this.expr.getType();
    }

    public Expr makeReference() {
        Expr ret = this.expr.makeReference();
        if (!(ret instanceof ParenExpr)) {
            return ret;
        }
        return super.makeReference();
    }

    public boolean canBeCopied() {
        return this.expr.canBeCopied();
    }

    public boolean isUltimatelyLiteral() {
        return this.expr.isUltimatelyLiteral();
    }

    public void unparse(CodeWriter writer) {
        writer.write('(');
        writer.write(this.expr);
        writer.write(')');
    }

    public ASTObject postAssignmentCheck(AssignmentCheckerPass walker) {
        if (this.expr instanceof LiteralExpr) {
            return (LiteralExpr)this.expr.copy().setSource(this);
        }
        return this;
    }

    protected void cgValue(CodeBuilder cb) {
        this.expr.cgValue(cb);
    }

    protected void cgValue(CodeBuilder cb, Type castTo) {
        this.expr.cgValue(cb, castTo);
    }

    protected void cgEffect(CodeBuilder cb) {
        this.expr.cgEffect(cb);
    }

    protected void cgBuffer(CodeBuilder cb) {
        this.expr.cgBuffer(cb);
    }

    protected void cgTest(CodeBuilder cb, Label tdest, Label fdest) {
        this.expr.cgTest(cb, tdest, fdest);
    }

    public Expr getExpr() {
        return this.expr;
    }

    public void setExpr(Expr _expr) {
        if (_expr != null) {
            _expr.setParent(this);
        }
        this.expr = _expr;
    }

    public ParenExpr(SourceLocation location, Expr _expr) {
        super(location);
        this.setExpr(_expr);
    }

    protected ParenExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        ParenExpr ret = new ParenExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.expr != null) {
            ret.setExpr((Expr)walker.process(this.expr));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.expr;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "expr";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setExpr((Expr)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 1;
    }

    public String getDefaultDisplayName() {
        return "ParenExpr()";
    }
}

