/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import java.util.HashMap;
import java.util.Map;
import org.aspectj.compiler.base.CompilerObject;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.NameType;
import org.aspectj.compiler.base.ast.NullType;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.bytecode.ClassManager;

public class PackageSO
extends CompilerObject {
    private String packageName;
    private Map typeCache = new HashMap();
    private Map childPackages = new HashMap();
    public ClassManager classManager;
    private static final Type NOT_FOUND = new NullType(null);

    public PackageSO(JavaCompiler compiler, String packageName, ClassManager classManager) {
        super(compiler);
        this.packageName = packageName;
        this.classManager = classManager;
    }

    public void addType(Type newType) {
        String className = newType.getTypeDec().getExtendedId();
        Type type = (Type)this.typeCache.get(className);
        if (type != null && type != newType) {
            type.getTypeDec().showError("duplicate type name not allowed: " + type.getString());
            newType.getTypeDec().showError("duplicate type name not allowed: " + type.getString());
        }
        if (this.childPackages.containsKey(className)) {
            newType.getTypeDec().showError(newType.getString() + " clashes with package of the same name");
            return;
        }
        this.typeCache.put(className, newType);
    }

    public Type findType(String className) {
        Type type = (Type)this.typeCache.get(className);
        if (type != null) {
            if (type == NOT_FOUND) {
                return null;
            }
            return type;
        }
        type = this.findTypeOnClassPath(className);
        if (type != null) {
            this.typeCache.put(className, type);
            ((NameType)type).setLazy();
            return type;
        }
        this.typeCache.put(className, NOT_FOUND);
        return null;
    }

    public boolean containsSubPackage(String packageName) {
        PackageSO p = (PackageSO)this.childPackages.get(packageName);
        if (p == null) {
            return false;
        }
        return p.size() > 0;
    }

    public PackageSO findPackage(String packageName) {
        PackageSO p = (PackageSO)this.childPackages.get(packageName);
        if (p != null) {
            return p;
        }
        p = new PackageSO(this.getCompiler(), this.makeName(this.packageName, packageName), this.classManager.makeSubPackageManager(packageName));
        this.childPackages.put(packageName, p);
        return p;
    }

    public int size() {
        return this.typeCache.size();
    }

    private final String makeName(String n1, String n2) {
        if (n1 == null) {
            return n2;
        }
        return n1 + '.' + n2;
    }

    public Type findTypeOnClassPath(String name) {
        TypeDec ret = this.classManager.findTypeDec(name);
        if (ret == null) {
            return null;
        }
        if (!ret.getFullName().equals(this.makeName(this.packageName, name))) {
            this.getCompiler().showMessage("    case mismatch, not loading: " + ret.getFullName());
            return null;
        }
        return ret.getType();
    }
}

