/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.ByteCodeCleanupPass;
import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.ConditionalOpExpr;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.LiteralExpr;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.base.bcg.Label;

public class OrOrOpExpr
extends ConditionalOpExpr {
    protected LiteralExpr halfFold(Type type, LiteralExpr lit1, LiteralExpr lit2) {
        return type.foldBitwiseOp("|", lit1, lit2);
    }

    public void walkFlow(FlowCheckerPass w) {
        w.process(this.getRand1());
        FlowCheckerPass.Vars p1 = w.getVars();
        w.setVars(p1.getFalse());
        w.process(this.getRand2());
        FlowCheckerPass.Vars p2 = w.getVars();
        w.setVars(p1.getTrue().join(p2.getTrue()), p2.getFalse());
    }

    public ASTObject postCleanup(ByteCodeCleanupPass w) {
        if (this.getRand1().isConstantTrue() || this.getRand2().isConstantFalse()) {
            return this.getRand1();
        }
        if (this.getRand1().isConstantFalse()) {
            return this.getRand2();
        }
        return this;
    }

    protected void cgTest(CodeBuilder cb, Label tdest, Label fdest) {
        Label mid = cb.genLabel();
        this.getRand1().cgTest(cb, tdest, mid);
        cb.emitLabel(mid);
        this.getRand2().cgTest(cb, tdest, fdest);
    }

    public OrOrOpExpr(SourceLocation location, Expr _rand1, String _op, Expr _rand2) {
        super(location, _rand1, _op, _rand2);
    }

    protected OrOrOpExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        OrOrOpExpr ret = new OrOrOpExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.rand1 != null) {
            ret.setRand1((Expr)walker.process(this.rand1));
        }
        ret.op = this.op;
        if (this.rand2 != null) {
            ret.setRand2((Expr)walker.process(this.rand2));
        }
        return ret;
    }

    public String getDefaultDisplayName() {
        return "OrOrOpExpr(op: " + this.op + ")";
    }
}

