/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.AssignExpr;
import org.aspectj.compiler.base.ast.AssignableExpr;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.NumericType;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public class NumericAssignExpr
extends AssignExpr {
    public Type discoverType() {
        Type ty1 = this.lhs.getType();
        Type ty2 = this.rhs.getType();
        if (!(ty1 instanceof NumericType) || !(ty2 instanceof NumericType)) {
            this.showOperatorTypeError(this.op, ty1, ty2);
        }
        return ty1;
    }

    protected void cgValue(CodeBuilder cb) {
        this.cgValueEffect(cb, true);
    }

    protected void cgEffect(CodeBuilder cb) {
        this.cgValueEffect(cb, false);
    }

    private void cgValueEffect(CodeBuilder cb, boolean needsValue) {
        AssignableExpr lhs = this.getLhs();
        Expr rhs = this.getRhs();
        Type lhsTy = lhs.getType();
        Type rhsTy = rhs.getType();
        String op = this.getOp();
        Type ty = this.getTypeManager().binaryNumericPromotion(lhsTy, rhsTy);
        lhs.cgLvalue(cb);
        lhs.cgDupLvalue(cb);
        lhs.cgLtoRvalue(cb);
        lhsTy.emitCast(cb, ty);
        rhs.cgValue(cb, ty);
        ty.emitNumericOp(cb, op);
        ty.emitCast(cb, lhsTy);
        if (needsValue) {
            lhs.cgDupRvalue(cb);
        }
        lhs.cgAssignment(cb);
    }

    public NumericAssignExpr(SourceLocation location, AssignableExpr _lhs, String _op, Expr _rhs) {
        super(location, _lhs, _op, _rhs);
    }

    protected NumericAssignExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        NumericAssignExpr ret = new NumericAssignExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.lhs != null) {
            ret.setLhs((AssignableExpr)walker.process(this.lhs));
        }
        ret.op = this.op;
        if (this.rhs != null) {
            ret.setRhs((Expr)walker.process(this.rhs));
        }
        return ret;
    }

    public String getDefaultDisplayName() {
        return "NumericAssignExpr(op: " + this.op + ")";
    }
}

