/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import java.io.IOException;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public class NullExpr
extends Expr {
    public Type discoverType() {
        return this.getTypeManager().nullType;
    }

    public void unparse(CodeWriter writer) throws IOException {
        writer.write("null");
    }

    public boolean canBeCopied() {
        return true;
    }

    public boolean isUltimatelyLiteral() {
        return true;
    }

    protected void cgValue(CodeBuilder cb) {
        cb.emitNULL();
    }

    protected void cgEffect(CodeBuilder cb) {
    }

    public boolean isConstantZero() {
        return true;
    }

    public NullExpr(SourceLocation location) {
        super(location);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        NullExpr ret = new NullExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        return ret;
    }

    public String getDefaultDisplayName() {
        return "NullExpr()";
    }
}

