/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import java.io.IOException;
import org.aspectj.compiler.base.AssignmentCheckerPass;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.ArrayInitializer;
import org.aspectj.compiler.base.ast.ArrayType;
import org.aspectj.compiler.base.ast.CodeDec;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.EmptyExpr;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.NewExpr;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeD;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public class NewArrayExpr
extends NewExpr {
    protected ArrayInitializer initializer;
    protected Exprs dimExprs;

    public Type discoverType() {
        Exprs dimExprs = this.getDimExprs();
        ArrayInitializer inits = this.getInitializer();
        ArrayType type = (ArrayType)this.getTypeD().getType();
        if (this.initializer == null) {
            int dimExprCount = dimExprs.size();
            int i = 0;
            while (i < dimExprCount) {
                Expr dimExpr = dimExprs.get(i);
                if (dimExpr instanceof EmptyExpr) break;
                if (!dimExpr.isAssignableTo(this.getTypeManager().intType)) {
                    dimExpr.showTypeError(dimExpr.getType(), this.getTypeManager().intType);
                }
                ++i;
            }
        }
        return type;
    }

    public Exprs getArgs() {
        return new Exprs(this.getSourceLocation());
    }

    public CodeDec getCodeDec() {
        return null;
    }

    public Type getCalledType() {
        return this.getTypeD().getType();
    }

    public void unparse(CodeWriter writer) throws IOException {
        ArrayType arrayType = (ArrayType)this.getTypeD().getType();
        Exprs exprs = this.getDimExprs();
        writer.writeKeyword("new");
        writer.requiredSpace();
        if (exprs == null) {
            writer.write(arrayType.getString());
            writer.optionalSpace();
            writer.write(this.initializer);
        } else {
            Type componentType = arrayType.getComponentType();
            while (componentType instanceof ArrayType) {
                componentType = ((ArrayType)componentType).getComponentType();
            }
            writer.write(componentType.getString());
            int i = 0;
            while (i < exprs.size()) {
                writer.write('[');
                writer.write(exprs.get(i));
                writer.write(']');
                ++i;
            }
        }
    }

    public void preAssignmentCheck(AssignmentCheckerPass walker) {
        Type componentType;
        if (this.getInitializer() != null && (componentType = ((ArrayType)this.getType()).getComponentType()) instanceof ArrayType) {
            ArrayType arrayComponentType = (ArrayType)componentType;
            Exprs exprs = this.initializer.getExprs();
            int i = exprs.size() - 1;
            while (i >= 0) {
                Expr expr = exprs.get(i);
                if (expr instanceof ArrayInitializer) {
                    exprs.set(i, this.getAST().makeNewArray(arrayComponentType, (ArrayInitializer)expr));
                }
                --i;
            }
        }
    }

    public ASTObject postAssignmentCheck(AssignmentCheckerPass walker) {
        if (this.getInitializer() != null) {
            Type componentType = ((ArrayType)this.getType()).getComponentType();
            Exprs exprs = this.initializer.getExprs();
            int i = exprs.size() - 1;
            while (i >= 0) {
                Expr expr = exprs.get(i);
                if (!expr.isAssignableTo(componentType)) {
                    expr.showTypeError(expr.getType(), componentType);
                }
                --i;
            }
        }
        return this;
    }

    private void typeCheck(Type ty, Expr e) {
        if (e instanceof ArrayInitializer) {
            if (!(ty instanceof ArrayType)) {
                this.showError("illegal initializer for " + ty.getString());
            } else {
                Type componentTy = ((ArrayType)ty).getComponentType();
                Exprs exprs = ((ArrayInitializer)e).getExprs();
                if (exprs != null) {
                    int len = exprs.size();
                    int i = 0;
                    while (i < len) {
                        Expr arrayInit = exprs.get(i);
                        this.typeCheck(componentTy, arrayInit);
                        ++i;
                    }
                }
            }
        }
    }

    protected void cgValue(CodeBuilder cb) {
        ArrayType type = (ArrayType)this.getTypeD().getType();
        int dims = type.getArrayDimCount();
        Type compTy = type.getComponentType();
        if (this.initializer == null) {
            int filledDims = 0;
            int i = 0;
            while (i < dims) {
                Expr e = this.dimExprs.get(i);
                if (e instanceof EmptyExpr) break;
                e.cgValue(cb);
                ++filledDims;
                ++i;
            }
            if (dims == 1) {
                compTy.emitNewarray(cb);
            } else {
                type.emitMultiNewarray(cb, filledDims);
            }
        } else {
            Exprs es = this.initializer.getExprs();
            int size = es.size();
            cb.emitIntConstant(size);
            compTy.emitNewarray(cb);
            int i = 0;
            while (i < size) {
                Expr e = es.get(i);
                if (!e.isConstantZero()) {
                    cb.emitDUP();
                    cb.emitIntConstant(i);
                    e.cgValue(cb, compTy);
                    compTy.emitAstore(cb);
                }
                ++i;
            }
        }
    }

    public ArrayInitializer getInitializer() {
        return this.initializer;
    }

    public void setInitializer(ArrayInitializer _initializer) {
        if (_initializer != null) {
            _initializer.setParent(this);
        }
        this.initializer = _initializer;
    }

    public Exprs getDimExprs() {
        return this.dimExprs;
    }

    public void setDimExprs(Exprs _dimExprs) {
        if (_dimExprs != null) {
            _dimExprs.setParent(this);
        }
        this.dimExprs = _dimExprs;
    }

    public NewArrayExpr(SourceLocation location, TypeD _typeD, ArrayInitializer _initializer, Exprs _dimExprs) {
        super(location, _typeD);
        this.setInitializer(_initializer);
        this.setDimExprs(_dimExprs);
    }

    protected NewArrayExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        NewArrayExpr ret = new NewArrayExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.typeD != null) {
            ret.setTypeD((TypeD)walker.process(this.typeD));
        }
        if (this.initializer != null) {
            ret.setInitializer((ArrayInitializer)walker.process(this.initializer));
        }
        if (this.dimExprs != null) {
            ret.setDimExprs((Exprs)walker.process(this.dimExprs));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 1: {
                return this.initializer;
            }
            case 2: {
                return this.dimExprs;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 1: {
                return "initializer";
            }
            case 2: {
                return "dimExprs";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 1: {
                this.setInitializer((ArrayInitializer)child);
                return;
            }
            case 2: {
                this.setDimExprs((Exprs)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 3;
    }

    public String getDefaultDisplayName() {
        return "NewArrayExpr()";
    }
}

