/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import java.io.IOException;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.ConstructorDec;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.TypeDec;

public class Modifiers
extends ASTObject {
    public static final int PUBLIC = 1;
    public static final int PRIVATE = 2;
    public static final int PROTECTED = 4;
    public static final int STATIC = 8;
    public static final int FINAL = 16;
    public static final int SYNCHRONIZED = 32;
    public static final int VOLATILE = 64;
    public static final int TRANSIENT = 128;
    public static final int NATIVE = 256;
    public static final int INTERFACE = 512;
    public static final int ABSTRACT = 1024;
    public static final int STRICT = 2048;
    public static final int PRIVILEGED = 65536;
    public static final int DEFAULT_PRINT_MASK = 3583;
    public static final int INTERFACE_METHOD_PRINT_MASK = 504;
    public static final int CONSTRUCTOR_PRINT_MASK = 1535;
    protected int value;

    public static boolean isPublic(int value) {
        return (value & 1) != 0;
    }

    public boolean isPublic() {
        return (this.value & 1) != 0;
    }

    public static boolean isFinal(int value) {
        return (value & 0x10) != 0;
    }

    public boolean isFinal() {
        return (this.value & 0x10) != 0;
    }

    public static boolean isPrivate(int value) {
        return (value & 2) != 0;
    }

    public boolean isPrivate() {
        return (this.value & 2) != 0;
    }

    public static boolean isProtected(int value) {
        return (value & 4) != 0;
    }

    public boolean isProtected() {
        return (this.value & 4) != 0;
    }

    public static boolean isPackagePrivate(int value) {
        return (value & 7) == 0;
    }

    public boolean isPackagePrivate() {
        return (this.value & 7) == 0;
    }

    public static boolean isInterface(int value) {
        return (value & 0x200) != 0;
    }

    public boolean isInterface() {
        return (this.value & 0x200) != 0;
    }

    public static boolean isStatic(int value) {
        return (value & 8) != 0;
    }

    public boolean isStatic() {
        return (this.value & 8) != 0;
    }

    public static boolean isAbstract(int value) {
        return (value & 0x400) != 0;
    }

    public boolean isAbstract() {
        return (this.value & 0x400) != 0;
    }

    public static boolean isStrict(int value) {
        return (value & 0x800) != 0;
    }

    public boolean isStrict() {
        return (this.value & 0x800) != 0;
    }

    public static boolean isPrivileged(int value) {
        return (value & 0x10000) != 0;
    }

    public boolean isPrivileged() {
        return (this.value & 0x10000) != 0;
    }

    public boolean isSynchronized() {
        return (this.value & 0x20) != 0;
    }

    public boolean isNative() {
        return (this.value & 0x100) != 0;
    }

    public boolean isTransient() {
        return (this.value & 0x80) != 0;
    }

    public boolean isVolatile() {
        return (this.value & 0x40) != 0;
    }

    protected void setAttribute(int mask, boolean set) {
        this.value = set ? (this.value |= mask) : (this.value &= ~mask);
    }

    public void setPublic(boolean v) {
        this.setAttribute(2, false);
        this.setAttribute(4, false);
        this.setAttribute(1, v);
    }

    public void setProtected() {
        this.setAttribute(2, false);
        this.setAttribute(1, false);
        this.setAttribute(4, true);
    }

    public void setPrivate(boolean v) {
        this.setAttribute(4, false);
        this.setAttribute(1, false);
        this.setAttribute(2, v);
    }

    public void setInterface(boolean v) {
        this.setAttribute(512, v);
    }

    public void setFinal(boolean v) {
        this.setAttribute(16, v);
    }

    public void setAbstract(boolean v) {
        this.setAttribute(1024, v);
    }

    public void setStatic(boolean v) {
        this.setAttribute(8, v);
    }

    public void setStrict(boolean v) {
        this.setAttribute(2048, v);
    }

    public void setSynchronized(boolean v) {
        this.setAttribute(32, v);
    }

    public boolean isWeakerThan(Modifiers other) {
        if (this.isPublic()) {
            return false;
        }
        if (this.isProtected()) {
            return other.isPublic();
        }
        if (this.isPackagePrivate()) {
            return other.isPublic() || other.isProtected();
        }
        if (this.isPrivate()) {
            return !other.isPrivate();
        }
        return false;
    }

    public boolean isMoreAccessibleThan(Modifiers other) {
        if (this.isPublic()) {
            return !other.isPublic();
        }
        if (this.isProtected()) {
            return !other.isPublic() && !other.isProtected();
        }
        if (this.isPackagePrivate()) {
            return other.isPrivate();
        }
        if (this.isPrivate()) {
            return false;
        }
        return false;
    }

    public int getFalseValue() {
        return 0;
    }

    public int getAcceptableClassValue() {
        int val = this.getValue() & 0x611;
        if (this.isProtected()) {
            val |= 1;
        }
        if (this.isInterface()) {
            val &= 1;
            val |= 0x600;
        } else {
            val |= 0x20;
        }
        return val;
    }

    public int getAcceptableInnerClassValue() {
        int val = this.getValue() & 0x61F;
        if (this.isInterface()) {
            val |= 0x408;
        }
        return val;
    }

    public int getAccessValue() {
        return this.getValue() & 7;
    }

    public String getAccessValueString() {
        if (this.isPublic()) {
            return "public";
        }
        if (this.isPrivate()) {
            return "private";
        }
        if (this.isProtected()) {
            return "protected";
        }
        return "package";
    }

    public void checkIllegalCombination(int c1, int c2) {
        if ((this.getValue() & c1) != 0 && (this.getValue() & c2) != 0) {
            this.showError("illegal combination of modifiers: " + this.toString(c1, false) + this.toString(c2, true));
        }
    }

    public void checkSpec() {
        this.checkIllegalCombination(1, 2);
        this.checkIllegalCombination(1, 4);
        this.checkIllegalCombination(4, 2);
        this.checkIllegalCombination(1024, 16);
        this.checkIllegalCombination(1024, 256);
        this.checkIllegalCombination(1024, 32);
        this.checkIllegalCombination(256, 2048);
        this.checkIllegalCombination(64, 16);
    }

    public boolean matches(Modifiers otherModifiers) {
        return (this.value & otherModifiers.getValue()) == this.value;
    }

    public String toShortString() {
        return this.toString();
    }

    public void unparse(CodeWriter writer) throws IOException {
        String modText = this.getParent() instanceof ConstructorDec ? this.toString(1535, false) : (this.getParent() instanceof MethodDec && this.getParent().getParent().getParent() instanceof TypeDec && !((TypeDec)this.getParent().getParent().getParent()).isConcrete() ? this.toString(504, false) : this.toString(3583, false));
        if (modText.length() > 0) {
            writer.write(modText);
        }
    }

    public String toString() {
        return this.toString(3583, true);
    }

    private String toString(int mask, boolean trim) {
        int val = this.value & mask;
        if (val == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if ((val & 1) != 0) {
            sb.append("public ");
        } else if ((val & 2) != 0) {
            sb.append("private ");
        } else if ((val & 4) != 0) {
            sb.append("protected ");
        }
        if ((val & 8) != 0) {
            sb.append("static ");
        }
        if ((val & 0x400) != 0) {
            sb.append("abstract ");
        }
        if ((val & 0x10) != 0) {
            sb.append("final ");
        }
        if ((val & 0x80) != 0) {
            sb.append("transient ");
        }
        if ((val & 0x40) != 0) {
            sb.append("volatile ");
        }
        if ((val & 0x100) != 0) {
            sb.append("native ");
        }
        if ((val & 0x20) != 0) {
            sb.append("synchronized ");
        }
        if ((val & 0x800) != 0 && (val & 0x500) == 0) {
            sb.append("strictfp ");
        }
        String s = sb.toString();
        if (trim) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int _value) {
        this.value = _value;
    }

    public Modifiers(SourceLocation location, int _value) {
        super(location);
        this.setValue(_value);
    }

    protected Modifiers(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        Modifiers ret = new Modifiers(this.getSourceLocation());
        ret.preCopy(walker, this);
        ret.value = this.value;
        return ret;
    }

    public String getDefaultDisplayName() {
        return "Modifiers(value: " + this.value + ")";
    }
}

