/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.EqualityTestOpExpr;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.IntLiteralExpr;
import org.aspectj.compiler.base.ast.IntegralType;
import org.aspectj.compiler.base.ast.LiteralExpr;
import org.aspectj.compiler.base.ast.NumericTestOpExpr;
import org.aspectj.compiler.base.ast.NumericType;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.base.bcg.Label;

public abstract class IntishType
extends IntegralType {
    public Expr getNullExpr() {
        return new IntLiteralExpr(this.getAST().getSourceLocation(), this, "0", 0);
    }

    public IntishType(JavaCompiler compiler) {
        super(compiler);
    }

    private LiteralExpr makeLit(int i) {
        return this.getAST().makeLiteral(i);
    }

    private LiteralExpr makeBooleanLit(boolean b) {
        return this.getAST().makeLiteral(b);
    }

    LiteralExpr foldPlusOp(LiteralExpr rand) {
        return this.makeLit(rand.getIntValue());
    }

    LiteralExpr foldMinusOp(LiteralExpr rand) {
        return this.makeLit(-rand.getIntValue());
    }

    LiteralExpr foldBitNotOp(LiteralExpr rand) {
        return this.makeLit(~rand.getIntValue());
    }

    LiteralExpr foldAddOp(LiteralExpr rand1, LiteralExpr rand2) {
        return this.makeLit(rand1.getIntValue() + rand2.getIntValue());
    }

    LiteralExpr foldNumericOp(String op, LiteralExpr lit1, LiteralExpr lit2) {
        AST ast = this.getAST();
        int a = lit1.getIntValue();
        int b = lit2.getIntValue();
        if (op == "-") {
            return ast.makeLiteral(a - b);
        }
        if (op == "%") {
            return ast.makeLiteral(a % b);
        }
        if (op == "/") {
            return ast.makeLiteral(a / b);
        }
        if (op == "*") {
            return ast.makeLiteral(a * b);
        }
        throw new RuntimeException("bad op " + op);
    }

    LiteralExpr foldBitwiseOp(String op, LiteralExpr lit1, LiteralExpr lit2) {
        AST ast = this.getAST();
        int a = lit1.getIntValue();
        int b = lit2.getIntValue();
        if (op == "&") {
            return ast.makeLiteral(a & b);
        }
        if (op == "|") {
            return ast.makeLiteral(a | b);
        }
        if (op == "^") {
            return ast.makeLiteral(a ^ b);
        }
        throw new RuntimeException("bad op " + op);
    }

    LiteralExpr foldShiftOp(String op, LiteralExpr lit1, LiteralExpr lit2) {
        AST ast = this.getAST();
        int a = lit1.getIntValue();
        int b = lit2.getIntValue();
        if (op == "<<") {
            return ast.makeLiteral(a << b);
        }
        if (op == ">>") {
            return ast.makeLiteral(a >> b);
        }
        if (op == ">>>") {
            return ast.makeLiteral(a >>> b);
        }
        throw new RuntimeException("bad op " + op);
    }

    LiteralExpr foldEqualityTestOp(String op, LiteralExpr lit1, LiteralExpr lit2) {
        AST ast = this.getAST();
        int a = lit1.getIntValue();
        int b = lit2.getIntValue();
        if (op == "==") {
            return ast.makeLiteral(a == b);
        }
        if (op == "!=") {
            return ast.makeLiteral(a != b);
        }
        throw new RuntimeException("bad op " + op);
    }

    LiteralExpr foldNumericTestOp(String op, LiteralExpr lit1, LiteralExpr lit2) {
        AST ast = this.getAST();
        int a = lit1.getIntValue();
        int b = lit2.getIntValue();
        if (op == "<") {
            return ast.makeLiteral(a < b);
        }
        if (op == "<=") {
            return ast.makeLiteral(a <= b);
        }
        if (op == ">=") {
            return ast.makeLiteral(a >= b);
        }
        if (op == ">") {
            return ast.makeLiteral(a > b);
        }
        throw new RuntimeException("bad op " + op);
    }

    final void emitAdd(CodeBuilder cb) {
        cb.emitIADD();
    }

    final void emitNumericOp(CodeBuilder cb, String op) {
        if (op == "-") {
            cb.emitISUB();
        } else if (op == "%") {
            cb.emitIREM();
        } else if (op == "/") {
            cb.emitIDIV();
        } else if (op == "*") {
            cb.emitIMUL();
        }
    }

    final void emitBitwiseOp(CodeBuilder cb, String op) {
        if (op == "&") {
            cb.emitIAND();
        } else if (op == "|") {
            cb.emitIOR();
        } else if (op == "^") {
            cb.emitIXOR();
        }
    }

    final void emitShiftOp(CodeBuilder cb, String op) {
        if (op == "<<") {
            cb.emitISHL();
        } else if (op == ">>") {
            cb.emitISHR();
        } else if (op == ">>>") {
            cb.emitIUSHR();
        }
    }

    final void emitEqualityCompare(CodeBuilder cb, String op, Label t, Label f) {
        if (op == "==") {
            cb.emitIF_ICMPEQ(t, f);
        } else if (op == "!=") {
            cb.emitIF_ICMPNE(t, f);
        }
    }

    final void emitNumericCompare(CodeBuilder cb, String op, Label t, Label f) {
        if (op == "<") {
            cb.emitIF_ICMPLT(t, f);
        } else if (op == "<=") {
            cb.emitIF_ICMPLE(t, f);
        } else if (op == ">=") {
            cb.emitIF_ICMPGE(t, f);
        } else if (op == ">") {
            cb.emitIF_ICMPGT(t, f);
        }
    }

    final void emitNeg(CodeBuilder cb) {
        cb.emitINEG();
    }

    void emitCast(CodeBuilder cb, Type castTo) {
        if (castTo != this) {
            ((NumericType)castTo).emitCastFromInt(cb);
        }
    }

    public final void emitLoad(CodeBuilder cb, int loc) {
        cb.emitILOAD(loc);
    }

    public final void emitStore(CodeBuilder cb, int loc) {
        cb.emitISTORE(loc);
    }

    public final void emitReturn(CodeBuilder cb) {
        cb.emitIRETURN();
    }

    final void emitZero(CodeBuilder cb) {
        cb.emitIntConstant(0);
    }

    final void emitOne(CodeBuilder cb) {
        cb.emitIntConstant(1);
    }

    final void emitMinusOne(CodeBuilder cb) {
        cb.emitIntConstant(-1);
    }

    boolean hasFastEqualityTestOp() {
        return true;
    }

    void emitFastEqualityTestOp(CodeBuilder cb, EqualityTestOpExpr e, Label t, Label f) {
        Expr rand1 = e.getRand1();
        Expr rand2 = e.getRand2();
        String op = e.getOp();
        if (rand1.isConstantZero()) {
            rand2.cgValue(cb, this);
            this.emitEqualityCompare0(cb, op, t, f);
        } else if (rand2.isConstantZero()) {
            rand1.cgValue(cb, this);
            this.emitEqualityCompare0(cb, op, t, f);
        } else {
            rand1.cgValue(cb, this);
            rand2.cgValue(cb, this);
            this.emitEqualityCompare(cb, op, t, f);
        }
    }

    private void emitEqualityCompare0(CodeBuilder cb, String op, Label t, Label f) {
        if (op == "==") {
            cb.emitIFEQ(t, f);
        } else if (op == "!=") {
            cb.emitIFNE(t, f);
        }
    }

    boolean hasFastNumericTestOp() {
        return true;
    }

    void emitFastNumericTestOp(CodeBuilder cb, NumericTestOpExpr e, Label t, Label f) {
        Expr rand1 = e.getRand1();
        Expr rand2 = e.getRand2();
        String op = e.getOp();
        if (rand1.isConstantZero()) {
            rand2.cgValue(cb, this);
            this.emit0Compare(cb, op, t, f);
        } else if (rand2.isConstantZero()) {
            rand1.cgValue(cb, this);
            this.emitCompare0(cb, op, t, f);
        } else {
            rand1.cgValue(cb, this);
            rand2.cgValue(cb, this);
            this.emitNumericCompare(cb, op, t, f);
        }
    }

    private void emit0Compare(CodeBuilder cb, String op, Label t, Label f) {
        if (op == "<") {
            cb.emitIFGT(t, f);
        } else if (op == "<=") {
            cb.emitIFGE(t, f);
        } else if (op == ">=") {
            cb.emitIFLE(t, f);
        } else if (op == ">") {
            cb.emitIFLT(t, f);
        }
    }

    private void emitCompare0(CodeBuilder cb, String op, Label t, Label f) {
        if (op == "<") {
            cb.emitIFLT(t, f);
        } else if (op == "<=") {
            cb.emitIFLE(t, f);
        } else if (op == ">=") {
            cb.emitIFGE(t, f);
        } else if (op == ">") {
            cb.emitIFGT(t, f);
        }
    }
}

