/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import java.io.IOException;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.MovingWalker;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeD;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public class InstanceofExpr
extends Expr {
    protected Expr expr;
    protected TypeD testTypeD;

    public Type discoverType() {
        return this.getTypeManager().booleanType;
    }

    public void unparse(CodeWriter writer) throws IOException {
        writer.write(this.expr);
        writer.write(" instanceof ");
        writer.write(this.testTypeD);
    }

    public boolean isAlwaysFalse() {
        return !this.expr.getType().isCoercableTo(this.testTypeD.getType());
    }

    public void checkSpec() {
        if (!this.testTypeD.getType().isReferenceType()) {
            this.testTypeD.showError("not a reference type");
        }
        if (this.isAlwaysFalse()) {
            this.showError("Impossible for " + this.expr.getType().getString() + " to be instanceof " + this.testTypeD.getType().getString());
        }
    }

    public ASTObject postMove(MovingWalker walker) {
        return this.simplify();
    }

    public Expr simplify() {
        if (this.expr.getType() == null) {
            return this;
        }
        if (this.testTypeD.getType().isAssignableFrom(this.expr.getType())) {
            return this.getAST().makeLiteral(true);
        }
        if (this.isAlwaysFalse()) {
            return this.getAST().makeLiteral(false);
        }
        return this;
    }

    protected void cgValue(CodeBuilder cb) {
        this.expr.cgValue(cb);
        this.testTypeD.getType().emitInstanceof(cb);
    }

    public Expr getExpr() {
        return this.expr;
    }

    public void setExpr(Expr _expr) {
        if (_expr != null) {
            _expr.setParent(this);
        }
        this.expr = _expr;
    }

    public TypeD getTestTypeD() {
        return this.testTypeD;
    }

    public void setTestTypeD(TypeD _testTypeD) {
        if (_testTypeD != null) {
            _testTypeD.setParent(this);
        }
        this.testTypeD = _testTypeD;
    }

    public InstanceofExpr(SourceLocation location, Expr _expr, TypeD _testTypeD) {
        super(location);
        this.setExpr(_expr);
        this.setTestTypeD(_testTypeD);
    }

    protected InstanceofExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        InstanceofExpr ret = new InstanceofExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.expr != null) {
            ret.setExpr((Expr)walker.process(this.expr));
        }
        if (this.testTypeD != null) {
            ret.setTestTypeD((TypeD)walker.process(this.testTypeD));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.expr;
            }
            case 1: {
                return this.testTypeD;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "expr";
            }
            case 1: {
                return "testTypeD";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setExpr((Expr)child);
                return;
            }
            case 1: {
                this.setTestTypeD((TypeD)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 2;
    }

    public String getDefaultDisplayName() {
        return "InstanceofExpr()";
    }
}

