/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CodeDec;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.FormalDec;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.TypeD;

public class Formals
extends ASTObject {
    protected int size;
    public FormalDec[] children;

    public CodeDec getEnclosingCodeDec() {
        if (this.getParent() instanceof CodeDec) {
            return (CodeDec)this.getParent();
        }
        return super.getEnclosingCodeDec();
    }

    public Set makeSet() {
        HashSet<FormalDec> ret = new HashSet<FormalDec>();
        int i = 0;
        int len = this.size();
        while (i < len) {
            ret.add(this.get(i));
            ++i;
        }
        return ret;
    }

    public Iterator iterator() {
        return new Iterator(){
            private int i = 0;

            public boolean hasNext() {
                return this.i < Formals.this.size;
            }

            public Object next() {
                return Formals.this.children[this.i++];
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean canBeCalledWith(Exprs parameters) {
        if (this.size() != parameters.size()) {
            return false;
        }
        int i = 0;
        while (i < parameters.size()) {
            if (!parameters.get(i).getType().isMethodConvertableTo(this.get(i).getType())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean matches(Formals otherFormals) {
        if (this.size() != otherFormals.size()) {
            return false;
        }
        int i = 0;
        while (i < this.size()) {
            if (!this.get(i).getType().isEquivalent(otherFormals.get(i).getType())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public FormalDec findName(String name) {
        int N = this.size();
        int i = 0;
        while (i < N) {
            if (this.get(i).getId().equals(name)) {
                return this.get(i);
            }
            ++i;
        }
        return null;
    }

    public Map findTransform(Formals otherFormals) {
        FormalDec[] formals1 = this.children;
        FormalDec[] formals2 = otherFormals.children;
        HashMap<String, FormalDec> ft = new HashMap<String, FormalDec>();
        if (formals1.length != formals2.length) {
            return null;
        }
        int i = 0;
        while (i < formals1.length) {
            if (!formals1[i].getType().isEquivalent(formals2[i].getType())) {
                return null;
            }
            ft.put(formals1[i].getName(), formals2[i]);
            ++i;
        }
        return ft;
    }

    public String toShortString() {
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        int N = this.size();
        int i = 0;
        while (i < N) {
            FormalDec child;
            if (i > 0) {
                buf.append(", ");
            }
            if ((child = this.get(i)) == null) {
                this.showWarning("null child: " + i + " : " + this.children.length);
            } else {
                TypeD typeD = child.getTypeD();
                if (typeD == null) {
                    child.showError("null typeD on :" + child.getId());
                }
                buf.append(typeD.toShortString());
            }
            ++i;
        }
        buf.append(")");
        return buf.toString();
    }

    public void unparse(CodeWriter writer) {
        writer.openParen('(');
        writer.writeChildrenWithCommas(this);
        writer.closeParen(')');
    }

    public Exprs makeExprs() {
        AST ast = this.getAST();
        int N = this.size();
        Exprs args = ast.makeExprs();
        int i = 0;
        while (i < N) {
            args.add(ast.makeVar(this.get(i)));
            ++i;
        }
        return args;
    }

    public Formals(SourceLocation location, FormalDec[] _children) {
        super(location);
        int i = 0;
        while (i < _children.length) {
            if (_children[i] != null) {
                _children[i].setParent(this);
            }
            ++i;
        }
        this.children = _children;
        this.size = _children.length;
    }

    public Formals(SourceLocation location) {
        this(location, new FormalDec[0]);
    }

    public Formals(SourceLocation location, FormalDec child1) {
        this(location, new FormalDec[]{child1});
    }

    public Formals(SourceLocation location, FormalDec child1, FormalDec child2) {
        this(location, new FormalDec[]{child1, child2});
    }

    public Formals(SourceLocation location, FormalDec child1, FormalDec child2, FormalDec child3) {
        this(location, new FormalDec[]{child1, child2, child3});
    }

    public ASTObject copyWalk(CopyWalker walker) {
        int N = this.size;
        FormalDec[] copiedChildren = new FormalDec[N];
        int newIndex = 0;
        int oldIndex = 0;
        while (oldIndex < N) {
            FormalDec newChild = (FormalDec)walker.process(this.children[oldIndex]);
            if (newChild != null) {
                copiedChildren[newIndex++] = newChild;
            }
            ++oldIndex;
        }
        Formals ret = new Formals(this.getSourceLocation(), copiedChildren);
        ret.size = newIndex;
        ret.setSource(this);
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        return this.get(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        this.set(childIndex, (FormalDec)child);
    }

    public String getChildNameAt(int childIndex) {
        return "formal" + childIndex;
    }

    public int getChildCount() {
        return this.size;
    }

    public int size() {
        return this.size;
    }

    public FormalDec get(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.children[index];
    }

    public void set(int index, FormalDec child) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.children[index] = child;
        child.setParent(this);
    }

    public void resize(int newSize) {
        if (newSize > this.children.length) {
            FormalDec[] newChildren = new FormalDec[this.children.length * 2 + 1];
            System.arraycopy(this.children, 0, newChildren, 0, this.children.length);
            this.children = newChildren;
        }
        this.size = newSize;
    }

    public void addAll(Formals collection) {
        this.addAll(this.size, collection);
    }

    public void addAll(int index, Formals collection) {
        int i = 0;
        while (i < collection.size()) {
            this.add(index + i, collection.get(i));
            ++i;
        }
    }

    public void add(FormalDec child) {
        this.add(this.size, child);
    }

    public void add(int index, FormalDec child) {
        if (child == null) {
            return;
        }
        if (index < 0 || index > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.resize(this.size + 1);
        int moveIndex = this.size - 1;
        while (moveIndex > index) {
            this.children[moveIndex] = this.children[moveIndex - 1];
            --moveIndex;
        }
        this.children[index] = child;
        child.setParent(this);
    }

    public void remove(int index) {
        if (index < 0 || index > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        --this.size;
        int moveIndex = index;
        while (moveIndex < this.size) {
            this.children[moveIndex] = this.children[moveIndex + 1];
            ++moveIndex;
        }
    }

    public String getDefaultDisplayName() {
        return "Formals()";
    }
}

