/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.ByteCodeCleanupPass;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.FrameLocPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Decs;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Stmt;
import org.aspectj.compiler.base.ast.TestStmt;
import org.aspectj.compiler.base.ast.VarDec;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.base.bcg.Label;

public class ForStmt
extends TestStmt {
    protected ASTObject init;
    protected Expr test;
    protected Exprs update;
    protected Stmt body;

    public boolean isBreakable() {
        return true;
    }

    public boolean isContinuable() {
        return true;
    }

    private void writeInit(CodeWriter writer) {
        if (this.init == null) {
            return;
        }
        if (this.init instanceof Decs) {
            Decs decs = (Decs)this.init;
            ((VarDec)decs.get(0)).unparse(writer, false, true);
            int i = 1;
            while (i < decs.size()) {
                writer.comma();
                writer.optionalSpace();
                ((VarDec)decs.get(i)).unparse(writer, false, false);
                ++i;
            }
        } else if (this.init instanceof VarDec) {
            ((VarDec)this.init).unparse(writer, false, true);
        } else {
            writer.write(this.init);
        }
    }

    public void checkSpec() {
        super.checkSpec();
        int i = 0;
        while (i < this.update.size()) {
            Expr expr = this.update.get(i);
            if (!expr.isLegalStmt()) {
                expr.showError("not a statement");
            }
            ++i;
        }
        this.body.requireStmt();
    }

    public void unparse(CodeWriter writer) {
        writer.writeKeyword("for");
        writer.requiredSpace();
        writer.openParen('(');
        this.writeInit(writer);
        writer.write("; ");
        if (!this.test.isSynthetic() || !this.test.isConstantTrue()) {
            writer.write(this.test);
        }
        writer.write("; ");
        writer.write(this.update);
        writer.closeParen(')');
        writer.optionalSpace();
        writer.write(this.body);
    }

    public void walkFlow(FlowCheckerPass w) {
        w.process(this.getInit());
        FlowCheckerPass.Set enteringPossiblyAssigned = w.popPossiblyAssigned();
        w.processBoolean(this.getTest());
        FlowCheckerPass.Vars p = w.getVars();
        FlowCheckerPass.Vars tv = p.getTrue();
        FlowCheckerPass.Vars fv = p.getFalse();
        w.setLive(!this.getTest().isConstantFalse());
        w.setVars(p.getTrue());
        w.enterContext(this);
        w.process(this.getBody());
        w.leaveContext();
        FlowCheckerPass.Vars v = w.getVars();
        FlowCheckerPass.Vars cv = w.getContinueVars(this);
        FlowCheckerPass.Vars bv = w.getBreakVars(this);
        w.setLive(true);
        w.setVars(v.join(cv));
        w.process(this.getUpdate());
        FlowCheckerPass.Vars uv = w.getVars();
        FlowCheckerPass.Set loopPossiblyAssigned = w.popPossiblyAssigned();
        w.checkLoopingFinals(this, loopPossiblyAssigned.inter(enteringPossiblyAssigned), uv);
        w.mergePossiblyAssigned(enteringPossiblyAssigned);
        w.mergePossiblyAssigned(loopPossiblyAssigned);
        w.setLive(!this.getTest().isConstantTrue() || w.isBroken(this));
        w.setVars(fv.join(bv));
    }

    public void walkCleanup(ByteCodeCleanupPass w) {
        if (this.getTest().isConstantFalse()) {
            w.process(this.getInit());
            return;
        }
        this.setInit(w.process(this.getInit()));
        w.setLive(true);
        w.enterContext(this);
        this.setBody((Stmt)w.process(this.getBody()));
        w.leaveContext();
        w.setLive(!this.getTest().isConstantTrue() || w.isBroken(this));
    }

    public ASTObject postCleanup(ByteCodeCleanupPass w) {
        if (this.getTest().isConstantFalse()) {
            return this.getInit();
        }
        return this;
    }

    protected void cgStmt(CodeBuilder cb) {
        Label testLab = cb.genLabel();
        Label startLab = cb.genLabel();
        Label updateLab = cb.genLabel();
        Label endLab = cb.genLabel();
        cb.enterBlock();
        if (this.init instanceof Stmt) {
            ((Stmt)this.init).cgTop(cb);
        } else if (this.init instanceof Exprs) {
            ((Exprs)this.init).cgEffects(cb);
        }
        cb.emitJump(testLab);
        cb.emitLabel(startLab);
        cb.enterNonWindingContext(this, endLab, updateLab);
        this.body.cgTop(cb);
        cb.leaveContext();
        cb.emitLabel(updateLab);
        this.update.cgEffects(cb);
        cb.emitLabel(testLab);
        this.test.cgTest(cb, startLab, endLab);
        cb.emitLabel(endLab);
        cb.exitBlock();
    }

    public void walkFrameLoc(FrameLocPass walker) {
        int start = walker.getfs();
        super.walkFrameLoc(walker);
        walker.setfs(start);
    }

    public ASTObject getInit() {
        return this.init;
    }

    public void setInit(ASTObject _init) {
        if (_init != null) {
            _init.setParent(this);
        }
        this.init = _init;
    }

    public Expr getTest() {
        return this.test;
    }

    public void setTest(Expr _test) {
        if (_test != null) {
            _test.setParent(this);
        }
        this.test = _test;
    }

    public Exprs getUpdate() {
        return this.update;
    }

    public void setUpdate(Exprs _update) {
        if (_update != null) {
            _update.setParent(this);
        }
        this.update = _update;
    }

    public Stmt getBody() {
        return this.body;
    }

    public void setBody(Stmt _body) {
        if (_body != null) {
            _body.setParent(this);
        }
        this.body = _body;
    }

    public ForStmt(SourceLocation location, ASTObject _init, Expr _test, Exprs _update, Stmt _body) {
        super(location);
        this.setInit(_init);
        this.setTest(_test);
        this.setUpdate(_update);
        this.setBody(_body);
    }

    protected ForStmt(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        ForStmt ret = new ForStmt(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.init != null) {
            ret.setInit(walker.process(this.init));
        }
        if (this.test != null) {
            ret.setTest((Expr)walker.process(this.test));
        }
        if (this.update != null) {
            ret.setUpdate((Exprs)walker.process(this.update));
        }
        if (this.body != null) {
            ret.setBody((Stmt)walker.process(this.body));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.init;
            }
            case 1: {
                return this.test;
            }
            case 2: {
                return this.update;
            }
            case 3: {
                return this.body;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "init";
            }
            case 1: {
                return "test";
            }
            case 2: {
                return "update";
            }
            case 3: {
                return "body";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setInit(child);
                return;
            }
            case 1: {
                this.setTest((Expr)child);
                return;
            }
            case 2: {
                this.setUpdate((Exprs)child);
                return;
            }
            case 3: {
                this.setBody((Stmt)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 4;
    }

    public String getDefaultDisplayName() {
        return "ForStmt()";
    }
}

