/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.NumericLiteralExpr;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.base.bcg.FieldBuilder;

public class FloatLiteralExpr
extends NumericLiteralExpr {
    protected float floatValue;

    public int getIntValue() {
        return (int)this.floatValue;
    }

    public long getLongValue() {
        return (long)this.floatValue;
    }

    public double getDoubleValue() {
        return this.floatValue;
    }

    public String getStringValue() {
        return "" + this.floatValue;
    }

    public FloatLiteralExpr(SourceLocation source, float _floatValue) {
        this(source, source.getCompiler().getTypeManager().floatType, FloatLiteralExpr.createUsefulString(_floatValue), _floatValue);
    }

    private static String createUsefulString(float f) {
        if (Float.isNaN(f)) {
            return "(0.0f / 0.0f)";
        }
        if (Float.isInfinite(f)) {
            return f > 0.0f ? "(1.0f / 0.0f)" : "(-1.0f / 0.0f)";
        }
        return f + "f";
    }

    protected void cgValue(CodeBuilder cb) {
        cb.emitFloatConstant(this.floatValue);
    }

    public void addConstant(FieldBuilder fb) {
        fb.setConstantValue(this.floatValue);
    }

    public boolean isConstantZero() {
        return this.floatValue == 0.0f;
    }

    public float getFloatValue() {
        return this.floatValue;
    }

    public void setFloatValue(float _floatValue) {
        this.floatValue = _floatValue;
    }

    public FloatLiteralExpr(SourceLocation location, Type _type, String _value, float _floatValue) {
        super(location, _type, _value);
        this.setFloatValue(_floatValue);
    }

    protected FloatLiteralExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        FloatLiteralExpr ret = new FloatLiteralExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        ret.type = this.type;
        ret.value = this.value;
        ret.floatValue = this.floatValue;
        return ret;
    }

    public String getDefaultDisplayName() {
        return "FloatLiteralExpr(type: " + this.type + ", " + "value: " + this.value + ", " + "floatValue: " + this.floatValue + ")";
    }
}

