/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import java.util.Iterator;
import java.util.Set;
import org.aspectj.compiler.base.ASTFixerPass;
import org.aspectj.compiler.base.AssignmentCheckerPass;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.ForwardReferenceChecker;
import org.aspectj.compiler.base.FrameLocPass;
import org.aspectj.compiler.base.InnerInfoPass;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.AssignExpr;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Field;
import org.aspectj.compiler.base.ast.FormalDec;
import org.aspectj.compiler.base.ast.Formals;
import org.aspectj.compiler.base.ast.FromDecStmt;
import org.aspectj.compiler.base.ast.InitializerDec;
import org.aspectj.compiler.base.ast.InterfaceDec;
import org.aspectj.compiler.base.ast.LiteralExpr;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.ReturnStmt;
import org.aspectj.compiler.base.ast.ScopeWalker;
import org.aspectj.compiler.base.ast.SemanticObject;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Stmts;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeD;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.ast.VarDec;
import org.aspectj.compiler.base.bcg.ClassfileBuilder;
import org.aspectj.compiler.base.bcg.FieldBuilder;
import org.aspectj.compiler.crosscuts.MixinImplementationPass;

public class FieldDec
extends VarDec {
    private boolean isFoldedFlag = false;
    private MethodDec backdoorGetterMethod;
    private MethodDec backdoorSetterMethod;
    private AssignExpr assignExpr = null;

    public Dec getEnclosingDec() {
        return this;
    }

    public void walkAssignmentCheck(AssignmentCheckerPass walker) {
        this.ensureFolded(walker);
    }

    public boolean isFolded() {
        return this.isFoldedFlag;
    }

    private void setFolded(boolean isFoldedFlag) {
        this.isFoldedFlag = isFoldedFlag;
    }

    public void ensureFolded(AssignmentCheckerPass walker) {
        if (!this.isFolded()) {
            this.setFolded(true);
            this.preAssignmentCheck(walker);
            this.walk(walker);
            this.postAssignmentCheck(walker);
        }
    }

    public boolean isField() {
        return true;
    }

    public String toShortString() {
        return this.addIntroducedFromType(this.getDeclaringType().toShortString() + "." + this.getId());
    }

    public SemanticObject makeCorrespondingSemanticObject() {
        return new Field(this);
    }

    public Field getField() {
        return (Field)this.getCorrespondingSemanticObject();
    }

    public String getKind() {
        return "field";
    }

    public ASTObject postFixAST(ASTFixerPass fixer) {
        if (this.getBytecodeTypeDec() instanceof InterfaceDec) {
            this.getModifiers().setValue(25);
        }
        if (this.isFinal() && this.initializer == null) {
            this.modifiers.setFinal(false);
        }
        return this;
    }

    public ASTObject postImplementMixin(MixinImplementationPass fixer) {
        TypeDec inTypeDec = this.getBytecodeTypeDec();
        if (!(inTypeDec instanceof InterfaceDec)) {
            return this;
        }
        if (this.isFinal() && this.isStatic()) {
            return this;
        }
        if (this.isStatic()) {
            ((InterfaceDec)inTypeDec).addToHelperClass(this);
            return null;
        }
        Type onInterfaceType = this.getDeclaringType();
        this.getBackdoorSetterMethod().setBody(null);
        this.getBackdoorGetterMethod().setBody(null);
        Set topmostImplementors = Type.filterTopTypes(Type.filterConcreteTypes(inTypeDec.getType().getSubTypes()));
        Iterator i = topmostImplementors.iterator();
        while (i.hasNext()) {
            Type implType = (Type)i.next();
            TypeDec implDec = implType.getTypeDec();
            FieldDec newDec = (FieldDec)fixer.copyToClass(this, implDec);
            implDec.getBody().add(0, newDec);
            newDec.setDeclaringType(implType);
            newDec.getBackdoorGetterMethod();
            newDec.getBackdoorSetterMethod();
        }
        return null;
    }

    public void walkScope(ScopeWalker walker) {
        Expr saveInitializer = this.initializer;
        this.initializer = null;
        super.walkScope(walker);
        this.initializer = saveInitializer;
        if (!walker.walkBodies() || this.initializer == null) {
            return;
        }
        walker.pushScope(this.makeBlockScope(walker));
        this.setInitializer((Expr)walker.process(this.initializer));
        walker.popScope();
    }

    private String makeBackdoorId(String kind) {
        String ret = this.getBytecodeId() + "_aj" + kind;
        return this.getAST().makeGeneratedName(ret);
    }

    public MethodDec getBackdoorGetterMethod() {
        if (this.backdoorGetterMethod != null) {
            return this.backdoorGetterMethod;
        }
        AST ast = this.getAST();
        String id = this.makeBackdoorId("get");
        Modifiers modifiers = ast.makeModifiers(1);
        if (this.isStatic()) {
            modifiers.setStatic(true);
        }
        Formals formals = ast.makeFormals();
        Expr thisExpr = this.isStatic() ? ast.makeTypeExpr(this.getBytecodeTypeDec().getType()) : ast.makeThis(this.getBytecodeTypeDec().getType());
        ReturnStmt stmt = ast.makeReturn(ast.makeGet(thisExpr, this));
        MethodDec ret = ast.makeMethod(modifiers, this.getTypeD().getType(), id, formals, ast.makeBlock(stmt));
        this.getBytecodeTypeDec().addToBody(ret);
        this.backdoorGetterMethod = ret;
        return this.backdoorGetterMethod;
    }

    public MethodDec getBackdoorSetterMethod() {
        if (this.backdoorSetterMethod != null) {
            return this.backdoorSetterMethod;
        }
        AST ast = this.getAST();
        String id = this.makeBackdoorId("set");
        Modifiers modifiers = ast.makeModifiers(1);
        if (this.isStatic()) {
            modifiers.setStatic(true);
        }
        FormalDec newValue = ast.makeFormal(this.getTypeD().getType(), "newValue");
        Formals formals = ast.makeFormals(newValue);
        ReturnStmt stmt = ast.makeReturn(ast.makeSet(this, (Expr)ast.makeVar(newValue)));
        MethodDec ret = ast.makeMethod(modifiers, this.getTypeD().getType(), id, formals, ast.makeBlock(stmt));
        this.getBytecodeTypeDec().addToBody(ret);
        this.backdoorSetterMethod = ret;
        return this.backdoorSetterMethod;
    }

    public void unparse(CodeWriter writer) {
        super.unparse(writer);
    }

    public boolean isConstant() {
        return this.isFinal() && !this.getType().isObject() && this.initializer != null && this.initializer instanceof LiteralExpr;
    }

    public AssignExpr getAssignExpr() {
        if (this.assignExpr != null) {
            return this.assignExpr;
        }
        if (this.isStatic() && this.getDeclaringType().isInterface() && this.getOptions().usejavac) {
            return null;
        }
        Expr fieldInit = this.getInitializer();
        AST ast = this.getAST();
        if (fieldInit != null && !this.isConstant()) {
            this.setInitializer(null);
            if (this.isFinal() && this.isSynthetic()) {
                this.getModifiers().setFinal(false);
            }
            fieldInit.clearParent();
            this.assignExpr = this.isStatic() ? ast.makeSet(this, fieldInit) : ast.makeSet((Expr)ast.makeThis(this.getBytecodeTypeDec().getType()), this, fieldInit);
            FromDecStmt stmt = new FromDecStmt(ast.getSourceLocation(), ast.makeStmt(this.assignExpr), this);
            Stmts stmts = ast.makeStmts(stmt);
            InitializerDec init = this.isStatic() ? ast.makeStaticInitializer(stmts) : ast.makeInitializer(stmts);
            init.setSource(this);
            int index = this.getBytecodeTypeDec().getBody().indexOf(this);
            this.getBytecodeTypeDec().getBody().add(index + 1, init);
            this.assignExpr.setSource(this);
            return this.assignExpr;
        }
        return null;
    }

    public void walkForwardReference(ForwardReferenceChecker w) {
        this.walk(w.createInitializerChecker(this.isStatic()));
        w.addFieldDec(this);
    }

    public void walkInnerInfo(InnerInfoPass w) {
        int context = w.inMember(this.isStatic());
        super.walkInnerInfo(w);
        w.restoreContext(context);
    }

    public void walkFrameLoc(FrameLocPass walker) {
    }

    protected void cgMember(ClassfileBuilder cb) {
        Expr init;
        if (this.getOptions().bcgverbose) {
            System.err.println("generating for " + this);
        }
        FieldBuilder fb = cb.getFieldBuilder();
        fb.addAccessFlags(this.getModifiers().getValue());
        fb.setName(this.getBytecodeId());
        fb.setDescriptor(this.getDescriptor());
        if (this.isDeprecated()) {
            fb.setDeprecated();
        }
        if ((init = this.getInitializer()) != null) {
            if (!(init instanceof LiteralExpr)) {
                this.showError("expected literal here: " + this.toShortString());
            }
            this.getType().foldCast((LiteralExpr)init).addConstant(fb);
        }
        cb.addField(fb);
    }

    public FieldDec(SourceLocation location, Modifiers _modifiers, TypeD _typeD, String _id, Expr _initializer) {
        super(location, _modifiers, _typeD, _id, _initializer);
    }

    protected FieldDec(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        FieldDec ret = new FieldDec(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.modifiers != null) {
            ret.setModifiers((Modifiers)walker.process(this.modifiers));
        }
        if (this.typeD != null) {
            ret.setTypeD((TypeD)walker.process(this.typeD));
        }
        ret.id = this.id;
        if (this.initializer != null) {
            ret.setInitializer((Expr)walker.process(this.initializer));
        }
        return ret;
    }

    public String getDefaultDisplayName() {
        return "FieldDec(id: " + this.id + ")";
    }
}

