/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.NumericLiteralExpr;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.base.bcg.FieldBuilder;

public class DoubleLiteralExpr
extends NumericLiteralExpr {
    protected double doubleValue;

    public int getIntValue() {
        return (int)this.doubleValue;
    }

    public long getLongValue() {
        return (long)this.doubleValue;
    }

    public float getFloatValue() {
        return (float)this.doubleValue;
    }

    public String getStringValue() {
        return "" + this.doubleValue;
    }

    public DoubleLiteralExpr(SourceLocation source, double _doubleValue) {
        this(source, source.getCompiler().getTypeManager().doubleType, DoubleLiteralExpr.createUsefulString(_doubleValue), _doubleValue);
    }

    private static String createUsefulString(double d) {
        if (Double.isNaN(d)) {
            return "(0.0 / 0.0)";
        }
        if (Double.isInfinite(d)) {
            return d > 0.0 ? "(1.0 / 0.0)" : "(-1.0 / 0.0)";
        }
        return d + "d";
    }

    protected void cgValue(CodeBuilder cb) {
        cb.emitDoubleConstant(this.doubleValue);
    }

    public void addConstant(FieldBuilder fb) {
        fb.setConstantValue(this.doubleValue);
    }

    public boolean isConstantZero() {
        return this.doubleValue == 0.0;
    }

    public double getDoubleValue() {
        return this.doubleValue;
    }

    public void setDoubleValue(double _doubleValue) {
        this.doubleValue = _doubleValue;
    }

    public DoubleLiteralExpr(SourceLocation location, Type _type, String _value, double _doubleValue) {
        super(location, _type, _value);
        this.setDoubleValue(_doubleValue);
    }

    protected DoubleLiteralExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        DoubleLiteralExpr ret = new DoubleLiteralExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        ret.type = this.type;
        ret.value = this.value;
        ret.doubleValue = this.doubleValue;
        return ret;
    }

    public String getDefaultDisplayName() {
        return "DoubleLiteralExpr(type: " + this.type + ", " + "value: " + this.value + ", " + "doubleValue: " + this.doubleValue + ")";
    }
}

