/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import java.io.IOException;
import org.aspectj.compiler.base.ByteCodeCleanupPass;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Stmt;
import org.aspectj.compiler.base.ast.TestStmt;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.base.bcg.Label;

public class DoStmt
extends TestStmt {
    protected Stmt body;
    protected Expr test;

    public boolean isBreakable() {
        return true;
    }

    public boolean isContinuable() {
        return true;
    }

    public void unparse(CodeWriter writer) throws IOException {
        writer.writeKeyword("do");
        writer.requiredSpace();
        writer.write(this.body);
        writer.writeKeyword("while");
        writer.requiredSpace();
        writer.parenExpr(this.test);
        writer.closeStmt();
    }

    public void checkSpec() {
        this.body.requireStmt();
        super.checkSpec();
    }

    public void walkFlow(FlowCheckerPass w) {
        FlowCheckerPass.Set enteringPossiblyAssigned = w.popPossiblyAssigned();
        w.enterContext(this);
        w.process(this.getBody());
        w.leaveContext();
        FlowCheckerPass.Vars v = w.getVars();
        FlowCheckerPass.Vars cv = w.getContinueVars(this);
        FlowCheckerPass.Vars bv = w.getBreakVars(this);
        boolean bodyLive = w.isLive();
        w.setVars(v.join(cv));
        w.processBoolean(this.getTest());
        FlowCheckerPass.Vars p = w.getVars();
        FlowCheckerPass.Vars tv = p.getTrue();
        FlowCheckerPass.Vars fv = p.getFalse();
        FlowCheckerPass.Set loopPossiblyAssigned = w.popPossiblyAssigned();
        w.checkLoopingFinals(this, loopPossiblyAssigned.inter(enteringPossiblyAssigned), tv);
        w.mergePossiblyAssigned(enteringPossiblyAssigned);
        w.mergePossiblyAssigned(loopPossiblyAssigned);
        w.setLive(w.isBroken(this) || !this.getTest().isConstantTrue() && (bodyLive || w.isContinued(this)));
        w.setVars(fv.join(bv));
    }

    public void walkCleanup(ByteCodeCleanupPass w) {
        w.enterContext(this);
        w.process(this.getBody());
        w.leaveContext();
        w.setLive(w.isBroken(this) || !this.getTest().isConstantTrue() && (w.isLive() || w.isContinued(this)));
    }

    protected void cgStmt(CodeBuilder cb) {
        Label startLab = cb.genLabel();
        Label testLab = cb.genLabel();
        Label endLab = cb.genLabel();
        cb.emitLabel(startLab);
        cb.enterNonWindingContext(this, endLab, testLab);
        this.getBody().cgTop(cb);
        cb.leaveContext();
        cb.emitLabel(testLab);
        this.getTest().cgTest(cb, startLab, endLab);
        cb.emitLabel(endLab);
    }

    public Stmt getBody() {
        return this.body;
    }

    public void setBody(Stmt _body) {
        if (_body != null) {
            _body.setParent(this);
        }
        this.body = _body;
    }

    public Expr getTest() {
        return this.test;
    }

    public void setTest(Expr _test) {
        if (_test != null) {
            _test.setParent(this);
        }
        this.test = _test;
    }

    public DoStmt(SourceLocation location, Stmt _body, Expr _test) {
        super(location);
        this.setBody(_body);
        this.setTest(_test);
    }

    protected DoStmt(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        DoStmt ret = new DoStmt(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.body != null) {
            ret.setBody((Stmt)walker.process(this.body));
        }
        if (this.test != null) {
            ret.setTest((Expr)walker.process(this.test));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.body;
            }
            case 1: {
                return this.test;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "body";
            }
            case 1: {
                return "test";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setBody((Stmt)child);
                return;
            }
            case 1: {
                this.setTest((Expr)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 2;
    }

    public String getDefaultDisplayName() {
        return "DoStmt()";
    }
}

