/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.ForwardReferenceChecker;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.MovingWalker;
import org.aspectj.compiler.base.ast.ScopeWalker;
import org.aspectj.compiler.base.ast.SemanticObject;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Stmt;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.ast.TypeDs;
import org.aspectj.compiler.base.bcg.ClassfileBuilder;
import org.aspectj.compiler.base.cst.BlockScope;
import org.aspectj.compiler.base.cst.CrosscuttingBlockScope;
import org.aspectj.compiler.base.cst.Scope;

public abstract class Dec
extends Stmt {
    protected SemanticObject semanticObject;
    private boolean isDeprecated;
    private boolean explicitlyLanguageVisible = false;
    private boolean explicitlyNonSynthetic = false;
    public Dec owner = null;
    private Type declaringType = null;
    private Type lexicalType = null;
    private Scope fromLexicalScope = null;
    public boolean forcePublic = false;
    private String bytecodeId = null;

    public SemanticObject getCorrespondingSemanticObject() {
        if (this.semanticObject == null) {
            this.semanticObject = this.makeCorrespondingSemanticObject();
        }
        return this.semanticObject;
    }

    public SemanticObject makeCorrespondingSemanticObject() {
        return null;
    }

    protected final BlockScope makeBlockScope(ScopeWalker walker) {
        Scope parent = walker.getScope();
        if (!walker.useJavaScopes() && this.fromLexicalScope != null) {
            return new CrosscuttingBlockScope(this.getCompiler(), this.fromLexicalScope, this.getDeclaringType());
        }
        return new BlockScope(this.getCompiler(), null);
    }

    public void requireStmt() {
        this.showError("statement required, but declaration found");
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public void setDeprecated(boolean isDeprecated) {
        this.isDeprecated = isDeprecated;
    }

    public boolean inStaticContext() {
        return this.isStatic();
    }

    public boolean isLanguageVisible() {
        return !this.isSynthetic() || this.explicitlyLanguageVisible;
    }

    public void setLanguageVisible() {
        this.explicitlyLanguageVisible = true;
    }

    public boolean isSynthetic() {
        if (this.explicitlyNonSynthetic) {
            return false;
        }
        return super.isSynthetic();
    }

    public void setExplicitlyNonSynthetic() {
        this.explicitlyNonSynthetic = true;
    }

    protected String addIntroducedFromType(String s) {
        if (!this.isIntroduced()) {
            return s;
        }
        return s + " from " + this.getLexicalType().toShortString();
    }

    public boolean isIntroduced() {
        return this.getLexicalType() != this.getDeclaringType();
    }

    public void setFromLexicalScope(Scope fromScope) {
        this.fromLexicalScope = fromScope;
    }

    public void setAllEnclosingTypes(Type type) {
        this.setDeclaringType(type);
        this.setLexicalType(type);
    }

    public void setDeclaringType(Type type) {
        this.declaringType = type;
    }

    public Type getDeclaringType() {
        if (this.declaringType == null) {
            this.declaringType = this.lookupDeclaringType();
        }
        return this.declaringType;
    }

    public void setLexicalType(Type type) {
        this.lexicalType = type;
    }

    public Type getLexicalType() {
        if (this.lexicalType == null) {
            this.lexicalType = this.lookupLexicalType();
        }
        return this.lexicalType;
    }

    public Type getOutermostLexicalType() {
        if (this.lexicalType == null) {
            return super.getOutermostLexicalType();
        }
        return this.lexicalType.getTypeDec().getOutermostLexicalType();
    }

    protected Type lookupDeclaringType() {
        if (this.getParent() == null) {
            this.showError("no parent: ");
            return null;
        }
        if (this.getParent().getParent() instanceof TypeDec) {
            return ((TypeDec)this.getParent().getParent()).getType();
        }
        return super.getDeclaringType();
    }

    protected Type lookupLexicalType() {
        if (this.getParent() == null) {
            return null;
        }
        if (this.getParent().getParent() instanceof TypeDec) {
            return ((TypeDec)this.getParent().getParent()).getType();
        }
        return super.getLexicalType();
    }

    public void walkForwardReference(ForwardReferenceChecker w) {
        this.walk(w.createBodyChecker());
    }

    public ASTObject postCopy(CopyWalker walker, ASTObject oldObject) {
        this.declaringType = null;
        this.lexicalType = null;
        this.explicitlyLanguageVisible = ((Dec)oldObject).explicitlyLanguageVisible;
        this.explicitlyNonSynthetic = ((Dec)oldObject).explicitlyNonSynthetic;
        walker.addMapping(((Dec)oldObject).getCorrespondingSemanticObject(), this.getCorrespondingSemanticObject());
        return super.postCopy(walker, oldObject);
    }

    public void preCopy(CopyWalker walker, ASTObject oldObject) {
        walker.addMapping(oldObject, this);
        walker.addMapping(((Dec)oldObject).getCorrespondingSemanticObject(), this.getCorrespondingSemanticObject());
    }

    public void preMove(MovingWalker walker) {
        walker.addMapping(this, this);
        walker.addMapping(this.getCorrespondingSemanticObject(), this.getCorrespondingSemanticObject());
    }

    public boolean isPublic() {
        return this.getModifiers().isPublic();
    }

    public boolean isFinal() {
        return this.getModifiers().isFinal();
    }

    public boolean isPrivate() {
        return this.getModifiers().isPrivate();
    }

    public boolean isProtected() {
        return this.getModifiers().isProtected();
    }

    public boolean isStatic() {
        return this.getModifiers().isStatic();
    }

    public boolean isAbstract() {
        return this.getModifiers().isAbstract();
    }

    public abstract Modifiers getModifiers();

    public void forcePublic() {
        if (!this.isPublic()) {
            this.forcePublic = true;
        }
    }

    public boolean isMoreAccessibleThan(Dec other) {
        return this.getModifiers().isMoreAccessibleThan(other.getModifiers());
    }

    public boolean isMoreSpecificThan(Dec other) {
        Type type1 = this.getDeclaringType();
        Type type2 = other.getDeclaringType();
        return type1.isMethodConvertableTo(type2);
    }

    public boolean isApplicable(Exprs parameters) {
        return true;
    }

    public boolean isAlmostApplicable(Exprs params) {
        return true;
    }

    boolean hasPrivilegedAccess(ASTObject fromWhere) {
        if (fromWhere == null) {
            return true;
        }
        Type fromType = fromWhere.getLexicalType();
        while (fromType != null) {
            TypeDec td = fromType.getTypeDec();
            if (td == null) {
                return false;
            }
            if (td.getModifiers().isPrivileged()) {
                return true;
            }
            fromType = td.getLexicalType();
        }
        return false;
    }

    public boolean isAccessible(ASTObject fromWhere) {
        return this.isAccessible(fromWhere, false);
    }

    public boolean isAccessible(ASTObject fromWhere, boolean inBytecode) {
        Type fromType;
        Type toType;
        if (this.isPublic()) {
            return true;
        }
        if (!inBytecode && this.hasPrivilegedAccess(fromWhere)) {
            return true;
        }
        if (inBytecode) {
            toType = this.getBytecodeType();
            fromType = fromWhere.getBytecodeTypeDec() == null ? null : fromWhere.getBytecodeTypeDec().getType();
        } else {
            toType = this.getLexicalType();
            fromType = fromWhere.getLexicalType();
        }
        if (fromType == null) {
            if (this.isPrivate()) {
                return false;
            }
            return this.samePackage(fromType, toType, fromWhere);
        }
        if (this.isPrivate()) {
            if (inBytecode) {
                return toType.getOutermostBytecodeType() == fromType.getOutermostBytecodeType();
            }
            if (fromType == null || toType == null) {
                return false;
            }
            return fromType.getOutermostLexicalType() == toType.getOutermostLexicalType();
        }
        if (this.isProtected()) {
            if (this.samePackage(fromType, toType, fromWhere)) {
                return true;
            }
            if (fromType == null || toType == null) {
                return false;
            }
            while (!fromType.isSubtypeOf(toType)) {
                if ((fromType = fromType.getTypeDec().getLexicalType()) != null) continue;
                return false;
            }
            if (this.isStatic()) {
                return true;
            }
            if (this instanceof TypeDec) {
                return true;
            }
            return fromWhere.hasLegalProtectedAccess(fromType);
        }
        return this.samePackage(fromType, toType, fromWhere);
    }

    public boolean samePackage(Type fromType, Type thisType, ASTObject fromWhere) {
        String p1 = thisType == null ? this.getCompilationUnit().getPackageName() : thisType.getPackageName();
        String p2 = fromType == null ? fromWhere.getCompilationUnit().getPackageName() : fromType.getPackageName();
        return Dec.nameMatches(p1, p2);
    }

    static boolean nameMatches(String p1, String p2) {
        if (p1 == null) {
            return p2 == null;
        }
        return p1.equals(p2);
    }

    public boolean isInherited(Type inType) {
        if (this.isPrivate()) {
            return this.isIntroduced();
        }
        if (this.isIntroduced()) {
            return true;
        }
        if (this.isAccessible(inType.getTypeDec().getBody())) {
            return true;
        }
        if (!(this instanceof TypeDec) && this.isAbstract()) {
            inType.getTypeDec().showError("The member '" + this.toShortString() + "' has default access and hence is not inherited and can not be made concrete");
        }
        return false;
    }

    public boolean conflictsWith(Dec otherDec) {
        if (!this.getId().equals(otherDec.getId())) {
            return false;
        }
        if (!this.isAccessible(otherDec) && !otherDec.isAccessible(this)) {
            return false;
        }
        return this.getDeclaringType() == otherDec.getDeclaringType();
    }

    public boolean checkOverride(Type inType, Dec otherDec) {
        return false;
    }

    public boolean dominates(Dec otherDec) {
        if (this == otherDec) {
            return false;
        }
        if (this.getDeclaringType() != otherDec.getDeclaringType()) {
            return false;
        }
        if (this.isIntroduced() && otherDec.isIntroduced()) {
            return this.getLexicalType().dominates(otherDec.getLexicalType());
        }
        return false;
    }

    public String getSignatureString() {
        CodeWriter writer = new CodeWriter(this.getCompiler());
        writer.setOnlySignatures(true);
        writer.write(this);
        return writer.getString();
    }

    public abstract String getKind();

    public String getBytecodeId() {
        if (this.bytecodeId == null) {
            return this.getId();
        }
        return this.bytecodeId;
    }

    public void setBytecodeId(String id) {
        this.bytecodeId = id;
    }

    public void setId(String id) {
    }

    public String getName() {
        return this.getId();
    }

    public abstract String getId();

    public abstract String toShortString();

    public void writeNames(CodeWriter writer, String label, TypeDs names) {
        if (names == null || names.size() == 0) {
            return;
        }
        writer.requiredSpace();
        writer.writeKeyword(label);
        writer.requiredSpace();
        writer.write(names);
    }

    public void writeModifiers(CodeWriter writer) {
        if (this.getModifiers() == null) {
            return;
        }
        if (this.forcePublic) {
            Modifiers mods = (Modifiers)this.getModifiers().copy();
            mods.setPublic(true);
            writer.write(mods);
        } else {
            writer.write(this.getModifiers());
        }
    }

    public void cleanup() {
        super.cleanup();
    }

    public String getDescriptor() {
        return null;
    }

    public int getStackDelta() {
        return 0;
    }

    protected void cgMember(ClassfileBuilder maker) {
    }

    public Dec(SourceLocation location) {
        super(location);
    }

    public String getDefaultDisplayName() {
        return "Dec()";
    }
}

