/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import java.util.Iterator;
import java.util.Set;
import org.aspectj.compiler.base.ASTFixerPass;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.LocalClassPass;
import org.aspectj.compiler.base.MemberClassMunger;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CastExpr;
import org.aspectj.compiler.base.ast.CodeBody;
import org.aspectj.compiler.base.ast.CodeDec;
import org.aspectj.compiler.base.ast.Constructor;
import org.aspectj.compiler.base.ast.ConstructorBody;
import org.aspectj.compiler.base.ast.ConstructorCallExpr;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Decs;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.FormalDec;
import org.aspectj.compiler.base.ast.Formals;
import org.aspectj.compiler.base.ast.InitializerDec;
import org.aspectj.compiler.base.ast.InterfaceDec;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.NameType;
import org.aspectj.compiler.base.ast.SemanticObject;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Stmt;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeD;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.ast.TypeDs;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.crosscuts.MixinImplementationPass;

public class ConstructorDec
extends CodeDec {
    FormalDec extraFormalDec = null;
    private String descriptor;
    private boolean isDeltaComputed = false;
    private int stackDelta;
    protected FormalDec enclosingInstanceFormal;

    public boolean isSuper() {
        ConstructorBody body = (ConstructorBody)this.getBody();
        return body.getConstructorCall().getIsSuper();
    }

    public ConstructorDec getNextConstructorDec() {
        ConstructorBody body = (ConstructorBody)this.getBody();
        return body.getConstructorCall().getConstructor().getConstructorDec();
    }

    public ASTObject postFixAST(ASTFixerPass fixer) {
        this.fixIntroducedDec(null);
        return this;
    }

    public String getId() {
        return "new";
    }

    public TypeD getResultTypeD() {
        return this.getTypeManager().voidType.makeTypeD();
    }

    public boolean isFinal() {
        return true;
    }

    public boolean isStatic() {
        return false;
    }

    public boolean appearsStaticToCaller() {
        return true;
    }

    public boolean hasThis() {
        return true;
    }

    private String getDeclaringTypeD() {
        if (this.getDeclaringType() == null) {
            return "";
        }
        return this.getDeclaringType().toShortString();
    }

    public String toShortString() {
        return this.modifiers.toShortString() + " " + this.getDeclaringTypeName() + this.formals.toShortString();
    }

    public String getKind() {
        return "constructor";
    }

    public SemanticObject makeCorrespondingSemanticObject() {
        return new Constructor(this);
    }

    public Constructor getConstructor() {
        return (Constructor)this.getCorrespondingSemanticObject();
    }

    public String toString() {
        return this.toShortString();
    }

    String getDeclaringTypeName() {
        return this.getDeclaringType().getId();
    }

    public FormalDec getExtraFormalDec() {
        if (this.extraFormalDec != null) {
            return this.extraFormalDec;
        }
        if (!this.isIntroduced()) {
            return null;
        }
        if (this.isPrivate()) {
            this.extraFormalDec = this.getAST().makeFormal(this.getLexicalType().getPrivateCookieType(), "ajc$cookie");
        } else {
            if (this.isProtected()) {
                this.showError("protected introduction not allowed");
                return null;
            }
            if (this.isPublic()) {
                return null;
            }
            this.extraFormalDec = this.getAST().makeFormal(this.getLexicalType().getPackageCookieType(), "ajc$cookie");
        }
        return this.extraFormalDec;
    }

    public Expr getExtraArgExpr() {
        FormalDec extraFormal = this.getExtraFormalDec();
        if (extraFormal == null) {
            return null;
        }
        return new CastExpr(this.getSourceLocation(), extraFormal.getTypeD(), this.getAST().makeNull());
    }

    protected void fixIntroducedAccessibility() {
        if (this.isPublic()) {
            return;
        }
        this.getFormals().add(this.getExtraFormalDec());
        this.getModifiers().setPublic(true);
    }

    protected void makeMixinConcrete(TypeDec onTypeDec) {
        CodeDec newDec = (CodeDec)this.copy();
        onTypeDec.getBody().add(newDec);
    }

    public void makePublicAccessible() {
        if (this.isIntroduced()) {
            this.fixIntroducedAccessibility();
        } else {
            this.getModifiers().setPublic(true);
        }
    }

    public void fixIntroducedDec(TypeDec onTypeDec) {
        Type superType;
        if (!this.isIntroduced()) {
            return;
        }
        if (onTypeDec == null || this.getDeclaringType().getTypeDec() == onTypeDec) {
            this.fixIntroducedAccessibility();
        } else if (!(!this.getDeclaringType().isInterface() || (superType = onTypeDec.getSuperClassType()).getTypeDec().fromSource() && superType.isSubtypeOf(this.getDeclaringType()))) {
            this.makeMixinConcrete(onTypeDec);
        }
    }

    public ASTObject postImplementMixin(MixinImplementationPass fixer) {
        TypeDec inTypeDec = this.getBytecodeTypeDec();
        if (!(inTypeDec instanceof InterfaceDec) || this.getBody() == null || this.isStatic()) {
            return this;
        }
        Set topmostImplementors = Type.filterTopTypes(Type.filterConcreteTypes(inTypeDec.getType().getSubTypes()));
        Iterator i = topmostImplementors.iterator();
        while (i.hasNext()) {
            Type implType = (Type)i.next();
            TypeDec implDec = implType.getTypeDec();
            CodeDec newDec = (CodeDec)fixer.copyToClass(this, implDec);
            newDec = this.getAST().makeInitializer(newDec.getBody().getStmts());
            Decs decs = implDec.getBody();
            int j = decs.size() - 1;
            while (j >= 0) {
                if (decs.get(j) instanceof InitializerDec) {
                    implDec.getBody().add(j, newDec);
                    break;
                }
                --j;
            }
            if (j >= 0) continue;
            implDec.getBody().add(newDec);
        }
        return null;
    }

    public void unparse(CodeWriter writer) {
        this.setAllEnclosingTypes(null);
        writer.write(this.modifiers);
        writer.write(this.getDeclaringTypeName());
        if (this.getEnclosingInstanceFormal() == null) {
            writer.write(this.formals);
        } else {
            Formals f = (Formals)this.formals.copy();
            f.add(0, (FormalDec)this.getEnclosingInstanceFormal().copy());
            writer.write(f);
        }
        this.writeNames(writer, "throws", this.getThrows());
        if (!writer.isOnlySignatures()) {
            writer.optionalSpace();
            writer.write(this.body);
        }
    }

    public void walkAnalysis(LocalClassPass.AnalysisWalker walker) {
        walker.enterCodeDec(this);
        walker.inConstructor();
        this.walk(walker);
        walker.leaveCodeDec();
    }

    public void preThreading(LocalClassPass.ThreadingWalker walker) {
        walker.pushConstructorEnv(this.getFormals());
    }

    public ASTObject postThreading(LocalClassPass.ThreadingWalker walker) {
        walker.popEnv();
        return this;
    }

    public ASTObject walkMemberMunger(MemberClassMunger w) {
        NameType currentType = w.currentType();
        if (currentType.isInner()) {
            AST ast = this.getAST();
            NameType enclosingInstanceType = currentType.getEnclosingInstanceType();
            FormalDec formalDec = ast.makeFormal(enclosingInstanceType, "enclosing$instance");
            this.setEnclosingInstanceFormal(formalDec);
            ConstructorBody body = (ConstructorBody)this.getBody();
            ConstructorCallExpr call = body.getConstructorCall();
            if (call.getIsSuper()) {
                Stmt stmt = ast.makeStmt(ast.makeSet((Expr)ast.makeThis(currentType), w.currentField(), (Expr)ast.makeVar(formalDec)));
                body.getStmts().add(0, stmt);
            }
        }
        return super.walkMemberMunger(w);
    }

    String getInternalId() {
        return "<init>";
    }

    protected void cgCodeMember(CodeBuilder cb) {
        cb.setMaxFrame(this.getFrameSize());
        cb.enterBlock();
        if (this.getEnclosingInstanceFormal() != null) {
            cb.enterVar(this.getEnclosingInstanceFormal());
        }
        Formals f = this.getFormals();
        int i = 0;
        int len = f.size();
        while (i < len) {
            cb.enterVar(f.get(i));
            ++i;
        }
        this.getBody().cgTop(cb);
        cb.exitBlock();
    }

    public synchronized String getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = "(";
            if (this.getEnclosingInstanceFormal() != null) {
                this.descriptor = this.descriptor + this.getEnclosingInstanceFormal().getType().getDescriptor();
            }
            Iterator i = this.getFormals().iterator();
            while (i.hasNext()) {
                FormalDec dec = (FormalDec)i.next();
                this.descriptor = this.descriptor + dec.getType().getDescriptor();
            }
            this.descriptor = this.descriptor + ")";
            this.descriptor = this.descriptor + this.getResultType().getDescriptor();
        }
        return this.descriptor;
    }

    public synchronized int getStackDelta() {
        if (!this.isDeltaComputed) {
            this.stackDelta = this.getEnclosingInstanceFormal() == null ? -1 : -2;
            Iterator i = this.getFormals().iterator();
            while (i.hasNext()) {
                FormalDec dec = (FormalDec)i.next();
                this.stackDelta -= dec.getType().getSlotCount();
            }
            this.isDeltaComputed = true;
        }
        return this.stackDelta;
    }

    public ConstructorDec(SourceLocation location, Modifiers _modifiers, Formals _formals, TypeDs __throws, CodeBody _body) {
        this(location, _modifiers, null, _formals, __throws, _body);
    }

    public FormalDec getEnclosingInstanceFormal() {
        return this.enclosingInstanceFormal;
    }

    public void setEnclosingInstanceFormal(FormalDec _enclosingInstanceFormal) {
        if (_enclosingInstanceFormal != null) {
            _enclosingInstanceFormal.setParent(this);
        }
        this.enclosingInstanceFormal = _enclosingInstanceFormal;
    }

    public ConstructorDec(SourceLocation location, Modifiers _modifiers, FormalDec _enclosingInstanceFormal, Formals _formals, TypeDs __throws, CodeBody _body) {
        super(location, _modifiers, _formals, __throws, _body);
        this.setEnclosingInstanceFormal(_enclosingInstanceFormal);
    }

    protected ConstructorDec(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        ConstructorDec ret = new ConstructorDec(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.modifiers != null) {
            ret.setModifiers((Modifiers)walker.process(this.modifiers));
        }
        if (this.enclosingInstanceFormal != null) {
            ret.setEnclosingInstanceFormal((FormalDec)walker.process(this.enclosingInstanceFormal));
        }
        if (this.formals != null) {
            ret.setFormals((Formals)walker.process(this.formals));
        }
        if (this._throws != null) {
            ret.setThrows((TypeDs)walker.process(this._throws));
        }
        if (this.body != null) {
            ret.setBody((CodeBody)walker.process(this.body));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.modifiers;
            }
            case 1: {
                return this.enclosingInstanceFormal;
            }
            case 2: {
                return this.formals;
            }
            case 3: {
                return this._throws;
            }
            case 4: {
                return this.body;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "modifiers";
            }
            case 1: {
                return "enclosingInstanceFormal";
            }
            case 2: {
                return "formals";
            }
            case 3: {
                return "throws";
            }
            case 4: {
                return "body";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setModifiers((Modifiers)child);
                return;
            }
            case 1: {
                this.setEnclosingInstanceFormal((FormalDec)child);
                return;
            }
            case 2: {
                this.setFormals((Formals)child);
                return;
            }
            case 3: {
                this.setThrows((TypeDs)child);
                return;
            }
            case 4: {
                this.setBody((CodeBody)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 5;
    }

    public String getDefaultDisplayName() {
        return "ConstructorDec()";
    }
}

