/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.LocalClassPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CodeBody;
import org.aspectj.compiler.base.ast.Constructor;
import org.aspectj.compiler.base.ast.ConstructorCallExpr;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.ScopeWalker;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Stmts;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public class ConstructorBody
extends CodeBody {
    protected ConstructorCallExpr constructorCall;

    protected void setupDefaultConstructorCall() {
        if (this.constructorCall == null) {
            Type superType = this.getDeclaringType().getTypeDec().getSuperClassType();
            Exprs args = this.getAST().makeExprs();
            Constructor superConstructor = superType.getConstructor(this, args, true);
            ConstructorCallExpr newCallExpr = this.getAST().makeSuperConstructorCall(superConstructor);
            this.setConstructorCall(newCallExpr);
        }
    }

    public void preScope(ScopeWalker walker) {
        if (this.stmts != null && walker.walkBodies()) {
            this.setupDefaultConstructorCall();
        }
        super.preScope(walker);
    }

    public ConstructorBody(SourceLocation location, Stmts _stmts, ConstructorCallExpr _constructorCall, boolean _parsed) {
        super(location, _stmts, _parsed);
        this.setConstructorCall(_constructorCall);
    }

    public void unparse(CodeWriter writer) {
        writer.openBlock();
        writer.write(this.constructorCall);
        writer.newLine();
        if (this.tmpStmts != null) {
            writer.write(this.tmpStmts);
        }
        writer.write(this.stmts);
        writer.closeBlock();
    }

    public void cleanup() {
        this.constructorCall = null;
        super.cleanup();
    }

    public void preThreading(LocalClassPass.ThreadingWalker walker) {
        if (this.getConstructorCall().getIsSuper()) {
            walker.addFieldSets(this.getStmts());
        }
    }

    protected void cgStmt(CodeBuilder cb) {
        this.getConstructorCall().cgEffect(cb);
        super.cgStmt(cb);
    }

    public ConstructorBody(SourceLocation location, Stmts _stmts, boolean _parsed, ConstructorCallExpr _constructorCall) {
        this(location, null, _stmts, _parsed, _constructorCall);
    }

    public ConstructorCallExpr getConstructorCall() {
        return this.constructorCall;
    }

    public void setConstructorCall(ConstructorCallExpr _constructorCall) {
        if (_constructorCall != null) {
            _constructorCall.setParent(this);
        }
        this.constructorCall = _constructorCall;
    }

    public ConstructorBody(SourceLocation location, Stmts _tmpStmts, Stmts _stmts, boolean _parsed, ConstructorCallExpr _constructorCall) {
        super(location, _tmpStmts, _stmts, _parsed);
        this.setConstructorCall(_constructorCall);
    }

    protected ConstructorBody(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        ConstructorBody ret = new ConstructorBody(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.tmpStmts != null) {
            ret.setTmpStmts((Stmts)walker.process(this.tmpStmts));
        }
        if (this.stmts != null) {
            ret.setStmts((Stmts)walker.process(this.stmts));
        }
        ret.parsed = this.parsed;
        if (this.constructorCall != null) {
            ret.setConstructorCall((ConstructorCallExpr)walker.process(this.constructorCall));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 2: {
                return this.constructorCall;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 2: {
                return "constructorCall";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 2: {
                this.setConstructorCall((ConstructorCallExpr)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 3;
    }

    public String getDefaultDisplayName() {
        return "ConstructorBody(parsed: " + this.parsed + ")";
    }
}

