/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CodeDec;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Decs;
import org.aspectj.compiler.base.ast.DummySourceLocation;
import org.aspectj.compiler.base.ast.Import;
import org.aspectj.compiler.base.ast.Imports;
import org.aspectj.compiler.base.ast.ScopeWalker;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.TextSourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.cst.CUScope;
import org.aspectj.compiler.base.parser.SourceInfo;

public class CompilationUnit
extends ASTObject {
    private CUScope scope = new CUScope(this.getCompiler(), null, this);
    private ArrayList ownDecs = new ArrayList();
    private String sourceCanonicalPath = null;
    private String sourceDirectory = null;
    protected String packageName;
    protected Imports imports;
    protected Decs decs;
    protected SourceInfo sourceInfo;
    protected boolean scanned;

    public CompilationUnit(JavaCompiler compiler, File _file) {
        this(new DummySourceLocation(compiler), null, null, null, new SourceInfo(_file, null), false);
        this.sourceLocation = new TextSourceLocation(this, 0, 0);
        this.setDecs(new Decs(this.getSourceLocation()));
    }

    public List getDefinedTypes() {
        return this.ownDecs;
    }

    public void addDefinedType(TypeDec dec) {
        this.ownDecs.add(dec);
    }

    public Type getDeclaringType() {
        return null;
    }

    public Type getLexicalType() {
        return null;
    }

    public TypeDec getBytecodeTypeDec() {
        return null;
    }

    public CodeDec getEnclosingCodeDec() {
        return null;
    }

    public CUScope getScope() {
        return this.scope;
    }

    public void preScope(ScopeWalker walker) {
        walker.enterCU(this);
    }

    public String toString() {
        return this.getSourceFile().toString();
    }

    public void cleanup() {
    }

    public void cleanupDefinedTypes() {
        this.ownDecs = new ArrayList();
    }

    public String getSourceCanonicalPath() {
        if (this.sourceCanonicalPath != null) {
            return this.sourceCanonicalPath;
        }
        File file = this.getSourceFile();
        if (file == null) {
            return null;
        }
        try {
            this.sourceCanonicalPath = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.sourceCanonicalPath;
    }

    public String getSourceDirectory() {
        if (this.sourceDirectory != null) {
            return this.sourceDirectory;
        }
        this.sourceDirectory = new File(this.getSourceCanonicalPath()).getParent();
        return this.sourceDirectory;
    }

    public File getSourceFile() {
        return this.sourceInfo.getFile();
    }

    public int getLine(int position) {
        if (this.sourceInfo == null) {
            return -1;
        }
        return this.sourceInfo.getLine(position);
    }

    public int getColumn(int position) {
        return this.sourceInfo.getColumn(position);
    }

    public CompilationUnit getCompilationUnit() {
        return this;
    }

    public void addTypesToTypeGraph() {
        ScopeWalker walker = new ScopeWalker(this.getCompiler(), this.getScope());
        Decs decs = this.getDecs();
        int i = 0;
        int N = decs.size();
        while (i < N) {
            TypeDec typeDec = (TypeDec)decs.get(i);
            typeDec.addToTypeGraph(walker);
            ++i;
        }
    }

    public void buildSignatures() {
        ScopeWalker walker = new ScopeWalker(this.getCompiler(), this.getScope());
        Decs decs = this.getDecs();
        int i = 0;
        int N = decs.size();
        while (i < N) {
            TypeDec typeDec = (TypeDec)decs.get(i);
            typeDec.buildSignatures(walker);
            ++i;
        }
    }

    public void checkSpec() {
        Imports imports = this.getImports();
        HashMap<String, Type> importedTypeNames = new HashMap<String, Type>();
        int i = 0;
        int N = imports.size();
        while (i < N) {
            Import imp = imports.get(i);
            if (!imp.getStar()) {
                Type t = imp.getType();
                Decs decs = this.getDecs();
                int j = 0;
                int M = decs.size();
                while (j < M) {
                    TypeDec typeDec = (TypeDec)decs.get(j);
                    String id = typeDec.getId();
                    if (t.getId().equals(id) && t != typeDec.getType()) {
                        imp.showError("import conflicts with definition of " + typeDec.getPrettyString());
                    }
                    ++j;
                }
                Type iType = (Type)importedTypeNames.get(t.getId());
                if (iType != null && iType != t) {
                    imp.showError("import conflicts with previous import of " + iType.getPrettyString());
                }
                importedTypeNames.put(t.getId(), t);
            }
            ++i;
        }
        if (this.getOptions().strict && this.sourceInfo != null) {
            Decs decs = this.getDecs();
            int i2 = 0;
            int N2 = decs.size();
            while (i2 < N2) {
                TypeDec typeDec = (TypeDec)decs.get(i2);
                if (typeDec.isPublic()) {
                    String id = typeDec.getId();
                    String filename = this.sourceInfo.getFile().getName();
                    if (!filename.startsWith(id)) {
                        this.showError("public class must be in file of same name, i.e " + id + ".java");
                    }
                }
                ++i2;
            }
        }
    }

    public void unparse(CodeWriter writer) {
        if (this.getPackageName() != null) {
            writer.writeKeyword("package");
            writer.requiredSpace();
            writer.write(this.getPackageName());
            writer.closeStmt();
        }
        writer.writeChildren(this.imports);
        writer.write(this.decs);
    }

    public final void generateBytecode(File outputDir) throws IOException {
        Iterator i = this.getDefinedTypes().iterator();
        while (i.hasNext()) {
            TypeDec typeDec = (TypeDec)i.next();
            typeDec.generateBytecode(outputDir);
        }
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String _packageName) {
        this.packageName = _packageName;
    }

    public Imports getImports() {
        return this.imports;
    }

    public void setImports(Imports _imports) {
        if (_imports != null) {
            _imports.setParent(this);
        }
        this.imports = _imports;
    }

    public Decs getDecs() {
        return this.decs;
    }

    public void setDecs(Decs _decs) {
        if (_decs != null) {
            _decs.setParent(this);
        }
        this.decs = _decs;
    }

    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    public void setSourceInfo(SourceInfo _sourceInfo) {
        this.sourceInfo = _sourceInfo;
    }

    public boolean getScanned() {
        return this.scanned;
    }

    public void setScanned(boolean _scanned) {
        this.scanned = _scanned;
    }

    public CompilationUnit(SourceLocation location, String _packageName, Imports _imports, Decs _decs, SourceInfo _sourceInfo, boolean _scanned) {
        super(location);
        this.setPackageName(_packageName);
        this.setImports(_imports);
        this.setDecs(_decs);
        this.setSourceInfo(_sourceInfo);
        this.setScanned(_scanned);
    }

    protected CompilationUnit(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        CompilationUnit ret = new CompilationUnit(this.getSourceLocation());
        ret.preCopy(walker, this);
        ret.packageName = this.packageName;
        if (this.imports != null) {
            ret.setImports((Imports)walker.process(this.imports));
        }
        if (this.decs != null) {
            ret.setDecs((Decs)walker.process(this.decs));
        }
        ret.sourceInfo = this.sourceInfo;
        ret.scanned = this.scanned;
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.imports;
            }
            case 1: {
                return this.decs;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "imports";
            }
            case 1: {
                return "decs";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setImports((Imports)child);
                return;
            }
            case 1: {
                this.setDecs((Decs)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 2;
    }

    public String getDefaultDisplayName() {
        return "CompilationUnit(packageName: " + this.packageName + ", " + "sourceInfo: " + this.sourceInfo + ", " + "scanned: " + this.scanned + ")";
    }
}

