/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import java.io.IOException;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeD;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public class ClassExpr
extends Expr {
    protected TypeD typeD;

    public Type discoverType() {
        return this.getTypeManager().getType("java.lang", "Class");
    }

    public void unparse(CodeWriter writer) throws IOException {
        writer.write(this.typeD);
        writer.write('.');
        writer.writeKeyword("class");
    }

    protected void cgValue(CodeBuilder cb) {
        throw new RuntimeException("Unhandled expression " + this);
    }

    public TypeD getTypeD() {
        return this.typeD;
    }

    public void setTypeD(TypeD _typeD) {
        if (_typeD != null) {
            _typeD.setParent(this);
        }
        this.typeD = _typeD;
    }

    public ClassExpr(SourceLocation location, TypeD _typeD) {
        super(location);
        this.setTypeD(_typeD);
    }

    protected ClassExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        ClassExpr ret = new ClassExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.typeD != null) {
            ret.setTypeD((TypeD)walker.process(this.typeD));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.typeD;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "typeD";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setTypeD((TypeD)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 1;
    }

    public String getDefaultDisplayName() {
        return "ClassExpr()";
    }
}

