/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.InnerInfoPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Decs;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.ScopeWalker;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeD;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.ast.TypeDs;

public class ClassDec
extends TypeDec {
    private boolean isAnonymousFlag = false;
    private boolean isInnerFlag = false;
    protected TypeD superClass;

    public String getKind() {
        return "class";
    }

    public boolean isAnonymous() {
        return this.isAnonymousFlag || this.getId().equals("ANONYMOUS");
    }

    public void setIsAnonymous() {
        this.isAnonymousFlag = true;
    }

    public ASTObject postCopy(CopyWalker walker, ASTObject oldObject) {
        this.isAnonymousFlag = ((ClassDec)oldObject).isAnonymousFlag;
        this.isInnerFlag = ((ClassDec)oldObject).isInnerFlag;
        if (walker.isStatic) {
            this.isInnerFlag = false;
        }
        return super.postCopy(walker, oldObject);
    }

    protected void walkExtendsAndImplements(ScopeWalker walker) {
        if (this.superClass != null) {
            this.setSuperClass((TypeD)walker.process(this.superClass));
        }
        super.walkExtendsAndImplements(walker);
    }

    public Type getSuperClassType() {
        Type superType = this.superClass == null ? this.getTypeManager().getObjectType() : this.superClass.getType();
        if (!this.type.isAspect() && superType.isAspect()) {
            this.superClass.showError("class may not extend an aspect");
        }
        if (superType.isClass()) {
            return superType;
        }
        if (!this.isAnonymous()) {
            this.superClass.showError(this.toShortString() + " must extend a class, not " + superType.toShortString());
            return this.getTypeManager().TYPE_NOT_FOUND;
        }
        this.setSuperInterfaces(this.getAST().makeTypeDs(this.superClass));
        superType = this.getTypeManager().getObjectType();
        this.setSuperClass(superType.makeTypeD());
        return superType;
    }

    public void unparse(CodeWriter writer) {
        writer.write(this.modifiers);
        writer.writeKeyword("class");
        writer.requiredSpace();
        writer.write(this.id);
        if (this.superClass != null) {
            writer.requiredSpace();
            writer.write("extends");
            writer.requiredSpace();
            writer.write(this.superClass);
        }
        this.writeNames(writer, "implements", this.superInterfaces);
        if (!writer.isOnlySignatures()) {
            writer.optionalSpace();
            writer.openBlock();
            writer.write(this.body);
            writer.newLine();
            writer.closeBlock();
        }
    }

    public void walkInnerInfo(InnerInfoPass w) {
        this.setIsInner(!this.isStatic() && w.isInDynamicContext());
        super.walkInnerInfo(w);
    }

    public void setIsInner(boolean b) {
        this.isInnerFlag = b;
    }

    public boolean isInner() {
        return this.isInnerFlag;
    }

    public TypeD getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(TypeD _superClass) {
        if (_superClass != null) {
            _superClass.setParent(this);
        }
        this.superClass = _superClass;
    }

    public ClassDec(SourceLocation location, Modifiers _modifiers, String _id, TypeD _superClass, TypeDs _superInterfaces, Decs _body) {
        super(location, _modifiers, _id, _superInterfaces, _body);
        this.setSuperClass(_superClass);
    }

    protected ClassDec(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        ClassDec ret = new ClassDec(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.modifiers != null) {
            ret.setModifiers((Modifiers)walker.process(this.modifiers));
        }
        ret.id = this.id;
        if (this.superClass != null) {
            ret.setSuperClass((TypeD)walker.process(this.superClass));
        }
        if (this.superInterfaces != null) {
            ret.setSuperInterfaces((TypeDs)walker.process(this.superInterfaces));
        }
        if (this.body != null) {
            ret.setBody((Decs)walker.process(this.body));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.modifiers;
            }
            case 1: {
                return this.superClass;
            }
            case 2: {
                return this.superInterfaces;
            }
            case 3: {
                return this.body;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "modifiers";
            }
            case 1: {
                return "superClass";
            }
            case 2: {
                return "superInterfaces";
            }
            case 3: {
                return "body";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setModifiers((Modifiers)child);
                return;
            }
            case 1: {
                this.setSuperClass((TypeD)child);
                return;
            }
            case 2: {
                this.setSuperInterfaces((TypeDs)child);
                return;
            }
            case 3: {
                this.setBody((Decs)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 4;
    }

    public String getDefaultDisplayName() {
        return "ClassDec(id: " + this.id + ")";
    }
}

