/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import java.io.IOException;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CatchClause;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.SourceLocation;

public class CatchClauses
extends ASTObject {
    protected int size;
    public CatchClause[] children;

    public void unparse(CodeWriter writer) throws IOException {
        writer.writeChildren(this);
    }

    public CatchClauses(SourceLocation location, CatchClause[] _children) {
        super(location);
        int i = 0;
        while (i < _children.length) {
            if (_children[i] != null) {
                _children[i].setParent(this);
            }
            ++i;
        }
        this.children = _children;
        this.size = _children.length;
    }

    public CatchClauses(SourceLocation location) {
        this(location, new CatchClause[0]);
    }

    public CatchClauses(SourceLocation location, CatchClause child1) {
        this(location, new CatchClause[]{child1});
    }

    public CatchClauses(SourceLocation location, CatchClause child1, CatchClause child2) {
        this(location, new CatchClause[]{child1, child2});
    }

    public CatchClauses(SourceLocation location, CatchClause child1, CatchClause child2, CatchClause child3) {
        this(location, new CatchClause[]{child1, child2, child3});
    }

    public ASTObject copyWalk(CopyWalker walker) {
        int N = this.size;
        CatchClause[] copiedChildren = new CatchClause[N];
        int newIndex = 0;
        int oldIndex = 0;
        while (oldIndex < N) {
            CatchClause newChild = (CatchClause)walker.process(this.children[oldIndex]);
            if (newChild != null) {
                copiedChildren[newIndex++] = newChild;
            }
            ++oldIndex;
        }
        CatchClauses ret = new CatchClauses(this.getSourceLocation(), copiedChildren);
        ret.size = newIndex;
        ret.setSource(this);
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        return this.get(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        this.set(childIndex, (CatchClause)child);
    }

    public String getChildNameAt(int childIndex) {
        return "clause" + childIndex;
    }

    public int getChildCount() {
        return this.size;
    }

    public int size() {
        return this.size;
    }

    public CatchClause get(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.children[index];
    }

    public void set(int index, CatchClause child) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.children[index] = child;
        child.setParent(this);
    }

    public void resize(int newSize) {
        if (newSize > this.children.length) {
            CatchClause[] newChildren = new CatchClause[this.children.length * 2 + 1];
            System.arraycopy(this.children, 0, newChildren, 0, this.children.length);
            this.children = newChildren;
        }
        this.size = newSize;
    }

    public void addAll(CatchClauses collection) {
        this.addAll(this.size, collection);
    }

    public void addAll(int index, CatchClauses collection) {
        int i = 0;
        while (i < collection.size()) {
            this.add(index + i, collection.get(i));
            ++i;
        }
    }

    public void add(CatchClause child) {
        this.add(this.size, child);
    }

    public void add(int index, CatchClause child) {
        if (child == null) {
            return;
        }
        if (index < 0 || index > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.resize(this.size + 1);
        int moveIndex = this.size - 1;
        while (moveIndex > index) {
            this.children[moveIndex] = this.children[moveIndex - 1];
            --moveIndex;
        }
        this.children[index] = child;
        child.setParent(this);
    }

    public void remove(int index) {
        if (index < 0 || index > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        --this.size;
        int moveIndex = index;
        while (moveIndex < this.size) {
            this.children[moveIndex] = this.children[moveIndex + 1];
            ++moveIndex;
        }
    }

    public String getDefaultDisplayName() {
        return "CatchClauses()";
    }
}

